/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class GenericConstraint
extends ResolverConstraint {
    private ArrayList matchingCapability;

    GenericConstraint(ResolverBundle bundle, VersionConstraint constraint) {
        super(bundle, constraint);
    }

    boolean isOptional() {
        return false;
    }

    boolean isSatisfiedBy(VersionSupplier vs) {
        return !vs.getResolverBundle().isUninstalled() && this.getVersionConstraint().isSatisfiedBy(vs.getBaseDescription());
    }

    public void setMatchingCapability(GenericCapability capability) {
        if (capability == null) {
            this.matchingCapability = null;
            return;
        }
        if (this.matchingCapability == null) {
            this.matchingCapability = new ArrayList(1);
        }
        this.matchingCapability.add(capability);
    }

    public GenericCapability[] getMatchingCapabilities() {
        return this.matchingCapability == null || this.matchingCapability.size() == 0 ? null : this.matchingCapability.toArray(new GenericCapability[this.matchingCapability.size()]);
    }

    void removeMatchingCapability(GenericCapability capability) {
        if (this.matchingCapability != null) {
            this.matchingCapability.remove(capability);
        }
    }
}

