/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class DNChainMatching {
    private static boolean rdnmatch(ArrayList rdn, ArrayList rdnPattern) {
        if (rdn.size() != rdnPattern.size()) {
            return false;
        }
        int i = 0;
        while (i < rdn.size()) {
            int patNameEnd;
            String rdnNameValue = (String)rdn.get(i);
            String patNameValue = (String)rdnPattern.get(i);
            int rdnNameEnd = rdnNameValue.indexOf(61);
            if (rdnNameEnd != (patNameEnd = patNameValue.indexOf(61)) || !rdnNameValue.regionMatches(0, patNameValue, 0, rdnNameEnd)) {
                return false;
            }
            String patValue = patNameValue.substring(patNameEnd);
            String rdnValue = rdnNameValue.substring(rdnNameEnd);
            if (!(rdnValue.equals(patValue) || patValue.equals("=*") || patValue.equals("=#16012a"))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean dnmatch(ArrayList dn, ArrayList dnPattern) {
        int dnStart = 0;
        int patStart = 0;
        int patLen = dnPattern.size();
        if (patLen == 0) {
            return false;
        }
        if (dnPattern.get(0).equals("*")) {
            patStart = 1;
            --patLen;
        }
        if (dn.size() < patLen) {
            return false;
        }
        if (dn.size() > patLen) {
            if (!dnPattern.get(0).equals("*")) {
                return false;
            }
            dnStart = dn.size() - patLen;
        }
        int i = 0;
        while (i < patLen) {
            if (!DNChainMatching.rdnmatch((ArrayList)dn.get(i + dnStart), (ArrayList)dnPattern.get(i + patStart))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ArrayList parseDNchain(String dnChain) throws IllegalArgumentException {
        ArrayList<Object> parsed = new ArrayList<Object>();
        int startIndex = 0;
        startIndex = DNChainMatching.skipSpaces(dnChain, startIndex);
        while (startIndex < dnChain.length()) {
            int endIndex = startIndex;
            boolean inQuote = false;
            block6: while (endIndex < dnChain.length()) {
                char c = dnChain.charAt(endIndex);
                switch (c) {
                    case '\"': {
                        inQuote = !inQuote;
                        break;
                    }
                    case '\\': {
                        ++endIndex;
                        break;
                    }
                    case ';': {
                        if (!inQuote) break block6;
                    }
                }
                ++endIndex;
            }
            if (endIndex > dnChain.length()) {
                throw new IllegalArgumentException("unterminated escape");
            }
            parsed.add(dnChain.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            startIndex = DNChainMatching.skipSpaces(dnChain, startIndex);
        }
        int i = 0;
        while (i < parsed.size()) {
            String dn = (String)parsed.get(i);
            if (!dn.equals("*")) {
                ArrayList<String> rdns = new ArrayList<String>();
                if (dn.charAt(0) == '*') {
                    if (dn.charAt(1) != ',') {
                        throw new IllegalArgumentException("invalid wildcard prefix");
                    }
                    rdns.add("*");
                    dn = new X500Principal(dn.substring(2)).getName("CANONICAL");
                } else {
                    dn = new X500Principal(dn).getName("CANONICAL");
                }
                DNChainMatching.parseDN(dn, rdns);
                parsed.set(i, rdns);
            }
            ++i;
        }
        if (parsed.size() == 0) {
            throw new IllegalArgumentException("empty DN chain");
        }
        return parsed;
    }

    private static int skipSpaces(String dnChain, int startIndex) {
        while (startIndex < dnChain.length() && dnChain.charAt(startIndex) == ' ') {
            ++startIndex;
        }
        return startIndex;
    }

    private static void parseDN(String dn, ArrayList rdnArray) throws IllegalArgumentException {
        int startIndex = 0;
        char c = '\u0000';
        ArrayList<String> nameValues = new ArrayList<String>();
        while (startIndex < dn.length()) {
            int endIndex = startIndex;
            while (endIndex < dn.length()) {
                c = dn.charAt(endIndex);
                if (c == ',' || c == '+') break;
                if (c == '\\') {
                    ++endIndex;
                }
                ++endIndex;
            }
            if (endIndex > dn.length()) {
                throw new IllegalArgumentException("unterminated escape " + dn);
            }
            nameValues.add(dn.substring(startIndex, endIndex));
            if (c != '+') {
                rdnArray.add(nameValues);
                nameValues = endIndex != dn.length() ? new ArrayList() : null;
            }
            startIndex = endIndex + 1;
        }
        if (nameValues != null) {
            throw new IllegalArgumentException("improperly terminated DN " + dn);
        }
    }

    private static int skipWildCards(ArrayList dnChainPattern, int dnChainPatternIndex) throws IllegalArgumentException {
        int i = dnChainPatternIndex;
        while (i < dnChainPattern.size()) {
            Object dnPattern = dnChainPattern.get(i);
            if (dnPattern instanceof String) {
                if (!dnPattern.equals("*")) {
                    throw new IllegalArgumentException("expected wild-card in DN pattern");
                }
            } else {
                if (dnPattern instanceof ArrayList) break;
                throw new IllegalArgumentException("expected String or Arraylist in DN Pattern");
            }
            ++i;
        }
        return i;
    }

    private static boolean dnChainMatch(ArrayList dnChain, int dnChainIndex, ArrayList dnChainPattern, int dnChainPatternIndex) throws IllegalArgumentException {
        if (dnChainIndex >= dnChain.size()) {
            return false;
        }
        if (dnChainPatternIndex >= dnChainPattern.size()) {
            return false;
        }
        Object dnPattern = dnChainPattern.get(dnChainPatternIndex);
        if (dnPattern instanceof String) {
            if (!dnPattern.equals("*")) {
                throw new IllegalArgumentException("expected wild-card in DN pattern");
            }
            if ((dnChainPatternIndex = DNChainMatching.skipWildCards(dnChainPattern, dnChainPatternIndex)) >= dnChainPattern.size()) {
                return true;
            }
            int i = dnChainIndex;
            while (i < dnChain.size()) {
                if (DNChainMatching.dnChainMatch(dnChain, i, dnChainPattern, dnChainPatternIndex)) {
                    return true;
                }
                ++i;
            }
        } else {
            if (dnPattern instanceof ArrayList) {
                do {
                    if (!DNChainMatching.dnmatch((ArrayList)dnChain.get(dnChainIndex), (ArrayList)dnPattern)) {
                        return false;
                    }
                    if (++dnChainIndex >= dnChain.size() && ++dnChainPatternIndex >= dnChainPattern.size()) {
                        return true;
                    }
                    if (dnChainIndex >= dnChain.size()) {
                        return (dnChainPatternIndex = DNChainMatching.skipWildCards(dnChainPattern, dnChainPatternIndex)) >= dnChainPattern.size();
                    }
                    if (dnChainPatternIndex >= dnChainPattern.size()) {
                        return false;
                    }
                    dnPattern = dnChainPattern.get(dnChainPatternIndex);
                    if (!(dnPattern instanceof String)) continue;
                    if (!dnPattern.equals("*")) {
                        throw new IllegalArgumentException("expected wild-card in DN pattern");
                    }
                    return DNChainMatching.dnChainMatch(dnChain, dnChainIndex, dnChainPattern, dnChainPatternIndex);
                } while (dnPattern instanceof ArrayList);
                throw new IllegalArgumentException("expected String or Arraylist in DN Pattern");
            }
            throw new IllegalArgumentException("expected String or Arraylist in DN Pattern");
        }
        return false;
    }

    public static boolean match(String dnChain, String pattern) {
        ArrayList parsedDNPattern;
        ArrayList parsedDNChain;
        try {
            parsedDNChain = DNChainMatching.parseDNchain(dnChain);
        }
        catch (IllegalArgumentException e) {
            System.err.println(String.valueOf(e.getMessage()) + ": " + dnChain);
            return false;
        }
        try {
            parsedDNPattern = DNChainMatching.parseDNchain(pattern);
        }
        catch (IllegalArgumentException e) {
            System.err.println(String.valueOf(e.getMessage()) + ": " + pattern);
            return false;
        }
        try {
            return DNChainMatching.dnChainMatch(parsedDNChain, 0, parsedDNPattern, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

