package org.etsi.t3d;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

import de.ugoe.cs.swe.trex.core.analyzer.rfparser.LocationAST;

public class DependencyPrinter {
	private PrintStream stream;
	private String currentTTCN3File;
	
	public void finishXML(){
		writeStream("\n</dependencies>");
		
	}
	
	public void newElement(String name, String id, int type, int line,
			String module, String dependencies) {
		writeStream("\n\t<element id=\""
				+ id
				+ "\" name=\""
				+ name
				+ "\" type=\""
				+ LocationAST.getTTCN3ParserTokenTypeTypePrettyName(type)
				+ "\" line=\""
				+ line
				+ "\" module=\""
				+ module
				+ "\" file=\""
				+ currentTTCN3File.substring(currentTTCN3File.lastIndexOf("/") + 1)
				+ "\">");
		writeStream(dependencies);
		writeStream("\n\t</element>\n");
	}

	public void newGroup(String name, String id, int type, int line, String module,
			String elementList) {
		writeStream("\n\t<element id=\""
				+ id
				+ "\" name=\""
				+ name
				+ "\" type=\""
				+ LocationAST.getTTCN3ParserTokenTypeTypePrettyName(type)
				+ "\" line=\""
				+ line
				+ "\" module=\""
				+ module
				+ "\" file=\""
				+ currentTTCN3File.substring(currentTTCN3File.lastIndexOf("/") + 1)
				+ "\">");
		writeStream(elementList);
		writeStream("\n\t</element>\n");
	}
	
	public void setXMLPath(String xmlpath){
		FileOutputStream file;
		try {
			file = new FileOutputStream(xmlpath);
			stream = new PrintStream(file);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		writeStream("<?xml-stylesheet type=\"text/xsl\" href=\"../dependencies.xsl\"?>\n<dependencies>");
	}

	private void writeStream(String content){
		stream.print(content);
	}
	
	public void setCurrentTTCN3File(String currentTTCN3File) {
		this.currentTTCN3File = currentTTCN3File;
	}

	public String getCurrentTTCN3File() {
		return currentTTCN3File;
	}
}
