#include "UEUserGuideClientMessages.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
void UEUserGuideClientRequest::SetTriggerCommand(const std::string & sTrigger, const std::vector<std::string> & vsParamsList)
{
	DisposeEncodedData();
	m_sTrigger = sTrigger;
	m_vsParamsList = vsParamsList;
}

unsigned int UEUserGuideClientRequest::CalculateDataLength()
{
	int nLen = TrafficCaptureMessage::CalculateDataLength() +
		CalculateStringLength(m_sTrigger) +
		sizeof(unsigned int);
	int nCount = m_vsParamsList.size();
	for (int i = 0; i < nCount; ++i)
		nLen += CalculateStringLength(m_vsParamsList[i]);
	return nLen;
}

void UEUserGuideClientRequest::EncodePayload(unsigned int & nOffset)
{
	TrafficCaptureMessage::EncodePayload(nOffset);
	EncodeString(m_sTrigger, nOffset);
	unsigned int nCount = m_vsParamsList.size();
	EncodeUInt(nCount, nOffset);
	for (unsigned int i = 0; i < nCount; ++i)
		EncodeString(m_vsParamsList[i], nOffset);
}

bool UEUserGuideClientRequest::DecodePayload(const char * pPayload, unsigned int nPayloadLength, 
									  unsigned int & nOffset)
{
	if (!TrafficCaptureMessage::DecodePayload(pPayload, nPayloadLength, nOffset))
		return false;
	if (!DecodeString(m_sTrigger, pPayload, nPayloadLength, nOffset))
		return false;
	unsigned int nCount = 0;
	if (!DecodeUInt(nCount, pPayload, nPayloadLength, nOffset))
		return false;
	m_vsParamsList.clear();
	for (unsigned int i = 0; i < nCount; ++i)
	{
		m_vsParamsList.push_back("");
		if (!DecodeString(m_vsParamsList[i], pPayload, nPayloadLength, nOffset))
			return false;
	}
	return true;
}

void UEUserGuideClientReply::EncodePayload(unsigned int & nOffset)
{
	TrafficCaptureMessage::EncodePayload(nOffset);
}

bool UEUserGuideClientReply::DecodePayload(const char * pPayload, unsigned int nPayloadLength, unsigned int & nOffset)
{
	if (!TrafficCaptureMessage::DecodePayload(pPayload, nPayloadLength, nOffset))
		return false;
	return true;
}

} } } // namespaces
