/**
 * @file Exceptions.h
 * Provides specific exceptions.
 * @author Yann garcia
 * @version 1.0
 * @date 25/07/2009
 */

#ifndef STF_370_Exceptions
#define STF_370_Exceptions

// standard exceptions
#include <iostream>
#include <string>
#include <exception>

class LowerTestAdapterException: public std::exception
{
private:
  std::string m_message;

public:
  LowerTestAdapterException(const char* message)
  {
	  m_message.assign(message);
  }
  ~LowerTestAdapterException() throw() {};

  virtual const char* what() const throw()
  {
    return m_message.c_str();
  }
};

class UpperTestAdapterException: public std::exception
{
private:
  std::string m_message;

public:
  UpperTestAdapterException(const char* message)
  {
	  m_message.assign(message);
  }
  ~UpperTestAdapterException() throw() {};

  virtual const char* what() const throw()
  {
    return m_message.c_str();
  }
};

#endif // STF_370_Exceptions
