package org.etsi.t3q.visitor;

import java.util.ArrayList;

import org.etsi.t3q.T3Q;


import de.ugoe.cs.swe.trex.core.analyzer.rfparser.TTCN3ParserTokenTypes;

public class ModuleContentsChecker extends AbstractModuleContentsChecker {

	public static final String TypesAndValuesModuleIDSubstring = "TypesAndValues";
	public static final String TemplatesModuleIDSubstring = "Templates";
	public static final String FunctionsModuleIDSubstring = "Functions";
	public static final String TestcasesModuleIDSubstring = "Testcases";
	public static final String ModuleParamsModuleIDSubstring = "ModuleParams";
	public static final String InterfaceModuleIDSubstring = "Interface";
	public static final String TestSystemModuleIDSubstring = "TestSystem";
	public static final String TestControlModuleIDSubstring = "TestControl";

	public ModuleContentsChecker() {
		super();
		addTypesAndValuesModulePermissibleTypes();
		addTemplatesModulePermissibleTypes();
		addFunctionsModulePermissibleTypes();
		addTestcasesModulePermissibleTypes();
		addModuleParamsModulePermissibleTypes();
		addInterfaceModulePermissibleTypes();
		addTestSystemModulePermissibleTypes();
		addTestControlModulePermissibleTypes();
	}

	private void addTypesAndValuesModulePermissibleTypes() {
		ArrayList<Integer> permissibleTypesList = new ArrayList<Integer>();

		permissibleTypesList.add(TTCN3ParserTokenTypes.TypeDef);
		permissibleTypesList.add(TTCN3ParserTokenTypes.ConstDef);

		addPermissibleListForModuleID(TypesAndValuesModuleIDSubstring,
				permissibleTypesList);
	}

	private void addTemplatesModulePermissibleTypes() {
		ArrayList<Integer> permissibleTypesList = new ArrayList<Integer>();

		permissibleTypesList.add(TTCN3ParserTokenTypes.TemplateDef);

		addPermissibleListForModuleID(TemplatesModuleIDSubstring,
				permissibleTypesList);

	}

	private void addFunctionsModulePermissibleTypes() {
		ArrayList<Integer> permissibleTypesList = new ArrayList<Integer>();
		permissibleTypesList.add(TTCN3ParserTokenTypes.FunctionDef);
		permissibleTypesList.add(TTCN3ParserTokenTypes.AltstepDef);
		if (T3Q.activeProfile.isCheckFunctionsModuleContainmentCheckAllowExtFunction()){
			permissibleTypesList.add(TTCN3ParserTokenTypes.ExtFunctionDef);
		}
		
		addPermissibleListForModuleID(FunctionsModuleIDSubstring,
				permissibleTypesList);

	}

	private void addTestcasesModulePermissibleTypes() {
		ArrayList<Integer> permissibleTypesList = new ArrayList<Integer>();
		permissibleTypesList.add(TTCN3ParserTokenTypes.TestcaseDef);
		permissibleTypesList.add(TTCN3ParserTokenTypes.FunctionDef);
		addPermissibleListForModuleID(TestcasesModuleIDSubstring,
				permissibleTypesList);

	}

	private void addModuleParamsModulePermissibleTypes() {
		ArrayList<Integer> permissibleTypesList = new ArrayList<Integer>();
		permissibleTypesList.add(TTCN3ParserTokenTypes.ModuleParDef);
		addPermissibleListForModuleID(ModuleParamsModuleIDSubstring,
				permissibleTypesList);

	}

	private void addInterfaceModulePermissibleTypes() {
		ArrayList<Integer> permissibleTypesList = new ArrayList<Integer>();
		permissibleTypesList.add(TTCN3ParserTokenTypes.ComponentDef);
		permissibleTypesList.add(TTCN3ParserTokenTypes.PortDef);
		addPermissibleListForModuleID(InterfaceModuleIDSubstring,
				permissibleTypesList);

	}

	private void addTestSystemModulePermissibleTypes() {
		ArrayList<Integer> permissibleTypesList = new ArrayList<Integer>();
		permissibleTypesList.add(TTCN3ParserTokenTypes.ComponentDef);
		addPermissibleListForModuleID(TestSystemModuleIDSubstring,
				permissibleTypesList);

	}

	private void addTestControlModulePermissibleTypes() {
		ArrayList<Integer> permissibleTypesList = new ArrayList<Integer>();
		//No definitions are permitted
		addPermissibleListForModuleID(TestControlModuleIDSubstring,
				permissibleTypesList);

	}

}
