package org.etsi.t3q.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import de.ugoe.cs.swe.trex.core.analyzer.rfparser.TTCN3ParserTokenTypes;

public abstract class AbstractModuleContentsChecker {

	private HashMap<String, ArrayList<Integer>> permissibleModuleContentsMap;

	public AbstractModuleContentsChecker() {
		this.permissibleModuleContentsMap = new HashMap<String, ArrayList<Integer>>();
	}

	protected void addPermissibleListForModuleID(String moduleIDSubstring,
			ArrayList<Integer> permissibleTypesList) {
		this.permissibleModuleContentsMap.put(moduleIDSubstring,
				permissibleTypesList);
	}
	
	public boolean typePermittedInRestrictedModule(String moduleRestriction, Integer type){
		boolean permitted = false;
		if (this.permissibleModuleContentsMap.get(moduleRestriction).contains(type) || (type == TTCN3ParserTokenTypes.ImportDef)){
			permitted = true;
		}
		return permitted;
	}
	
	public String checkModuleIDForRestrictions(String moduleID){
		String moduleRestriction = null;
		Iterator<String> moduleRestrictionIterator = this.permissibleModuleContentsMap.keySet().iterator();
		while (moduleRestrictionIterator.hasNext()){
			String moduleRestrictionEntry = moduleRestrictionIterator.next();
			if (moduleID.contains(moduleRestrictionEntry)){
				if (moduleRestriction!=null){
					//TODO: throw a warning that multiple restrictions are used
				}
				moduleRestriction = moduleRestrictionEntry;
			}
		}
		return moduleRestriction;
	}
}
