package de.ugoe.cs.swe.trex.core.analyzer.rfparser;

import antlr.SemanticException;

public class TTCN3SemanticException extends SemanticException implements Comparable<TTCN3SemanticException> {

	private static final long serialVersionUID = 1L;

	public enum warningEnum {
		ERROR, WARNING
	};

	private warningEnum warningType;

	public TTCN3SemanticException(String s, String fileName, int line,
			int column, warningEnum warningType) {
		super(s, fileName, line, column);
		this.warningType = warningType;
	}

	public warningEnum getWarningType() {
		return warningType;
	}

	public void setWarningType(warningEnum warningType) {
		this.warningType = warningType;
	}

	public int compareTo(TTCN3SemanticException o) {
		if (this.getLine() < o.getLine())
			return -1;
		else if (this.getLine() == o.getLine())
			return 0;
		else
			return 1;
	}
	
}
