<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" version="2.0">
<xsl:output method="xhtml" indent="yes" name="html" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/>

<xsl:param name="folder"/>
<xsl:param name="includeconstructbodies"/>
<xsl:param name="hideconstructbodies"/>
<xsl:param name="showOriginalT3DocTags"/>
<xsl:template match="/">

<!-- main view index page -->
 <xsl:variable name="filename" select="concat('file:///', $folder, '/html/index.html')"/>
 <xsl:value-of select="$filename"/>
 <xsl:result-document href="{$filename}" format="html">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <xsl:call-template name="html_head">
  <xsl:with-param name="title" select="'Main Index'"/>
 </xsl:call-template>  
 <body onload="init(); toggleConstructbodies('{$hideconstructbodies}');">
  <xsl:call-template name="views"/>
  <xsl:call-template name="main_index">
   <xsl:with-param name="modulename" select="'_T3D_FullIndex_'"/>
  </xsl:call-template>
  <p id="p_header">Index</p>
  <div id="div_content">
   <div id="div_statistics">
    <table id="table_statistics">
     <tr>
      <th>Module</th>
      <th>Documentation Files</th>     
      <th>Documentation Tags</th>       
     </tr>
     <xsl:for-each select="//module">
      <xsl:sort select="name/text()"/>
      <xsl:variable name="modulename" select="name/text()"/>
      <tr>
       <td class="td_table_statistics_modules"><a href="{concat(name/text(), '.html')}"><xsl:value-of select="name/text()"/></a></td>
       <td>
        <xsl:value-of select="count(//element[modulename/text() eq $modulename] | //group[modulename/text() eq $modulename]) + count(//element[modulename/text() eq $modulename and (@type eq 'Testcase' or @type eq 'Module Parameter')]) + 3"/>
       </td>
       <td>
        <xsl:value-of select="count((. | //element[modulename/text() eq $modulename] | //group[modulename/text() eq $modulename])/comment/(author | config | desc | exception | member | param | purpose | remark | return | see | since | status | url | verdict | version))"/>
       </td>       
      </tr>       
     </xsl:for-each>
    </table>    
   </div>
  </div>
 </body>
</html>
 </xsl:result-document> 
 
<!-- import view index page --> 
 <xsl:variable name="filename_import" select="concat('file:///', $folder, '/html/import_index.html')"/>
 <xsl:value-of select="$filename_import"/>
 <xsl:result-document href="{$filename_import}" format="html">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <xsl:call-template name="html_head">
  <xsl:with-param name="title" select="'Import View'"/>
 </xsl:call-template>
 <body onload="init();">
  <xsl:call-template name="views">
   <xsl:with-param name="togglemode" select="'import'"/>
  </xsl:call-template>
  <xsl:call-template name="index_modulelist">
   <xsl:with-param name="prefix" select="'import_'"/>
  </xsl:call-template>
  <p id="p_header">Import  View</p> 
  <div id="div_content">
   <div id="div_import">
    <table id="table_import">
     <tr>
      <th><span class="imports">imports</span></th><th>Modules</th><th><span class="importedby">imported by</span></th>
     </tr>
     <tr>
      <td>
      </td>
      <td id="table_import_modules">
       <xsl:for-each select="//module">
        <xsl:sort select="name/text()"/>
        <p>
          <a href="{concat('import_',./name/text(), '.html')}"><xsl:value-of select="./name/text()"/></a>
        </p>
       </xsl:for-each>
      </td>
      <td>
      </td>
     </tr>
    </table>
   </div>
  </div>
 </body>
</html>
 </xsl:result-document>

<!-- module parameter view index page -->  
 <xsl:variable name="filename_mp" select="concat('file:///', $folder, '/html/mp_index.html')"/>
 <xsl:value-of select="$filename_mp"/>
 <xsl:result-document href="{$filename_mp}" format="html">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <xsl:call-template name="html_head">
  <xsl:with-param name="title" select="'Module Parameter/Testcase View Index'"/>
 </xsl:call-template>
 <body onload="mp_init()">
  <xsl:call-template name="views">
   <xsl:with-param name="togglemode" select="'mp'"/>
  </xsl:call-template>
  <xsl:call-template name="mp_index">
   <xsl:with-param name="modulename" select="'_T3D_FullIndex_'"/>
  </xsl:call-template>
  <p id="p_header">Module Parameter/Testcase View</p> 
  <div id="div_content">
   <xsl:call-template name="mp_allTables">
    <xsl:with-param name="parameters" select="//mpview_ModuleParDef"/>
    <xsl:with-param name="testcases" select="//element[@type eq 'Testcase']"/>
   </xsl:call-template>
  </div>
 </body>
</html>
 </xsl:result-document>
<!-- /index -->
<!-- module -->
<xsl:for-each select="//module">
 <xsl:variable name="currentmodule" select="name/text()"/>
 <xsl:variable name="currentindex">
  <xsl:call-template name="main_index">
   <xsl:with-param name="modulename" select="$currentmodule"/>
  </xsl:call-template>
 </xsl:variable>
 <xsl:variable name="currentmp_index">
  <xsl:call-template name="mp_index">
   <xsl:with-param name="modulename" select="$currentmodule"/>
  </xsl:call-template>
 </xsl:variable>
 
 <xsl:variable name="filename" select="concat('file:///', $folder, '/html/', name/text(), '.html')"/>
 <xsl:value-of select="$filename"/>
 <xsl:result-document href="{$filename}" format="html">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <xsl:call-template name="html_head">
  <xsl:with-param name="title" select="name/text()"/>
 </xsl:call-template>  
 <body onload="init('module'); toggleConstructbodies('{$hideconstructbodies}');">   
  <xsl:call-template name="main_allElements">
   <xsl:with-param name="this" select="."/>
   <xsl:with-param name="currentindex" select="$currentindex"/>
  </xsl:call-template>
 </body>
</html>
</xsl:result-document>
<!-- /module -->
<!-- module mp_view -->
 <xsl:variable name="filename" select="concat('file:///', $folder, '/html/mp_', name/text(), '.html')"/>
 <xsl:value-of select="$filename"/>
 <xsl:result-document href="{$filename}" format="html">
  <xsl:variable name="modulename" select="name/text()"/>
  
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <xsl:call-template name="html_head">
  <xsl:with-param name="title" select="concat($modulename, ' - Module Parameter/Testcase View')"/>
 </xsl:call-template>
 <body onload="mp_init('module')">    
  <xsl:call-template name="views">
   <xsl:with-param name="main" select="concat($modulename, '.html')"/>
   <xsl:with-param name="mp" select="concat($modulename, '.html')"/>
   <xsl:with-param name="import" select="concat($modulename, '.html')"/>
   <xsl:with-param name="togglemode" select="'mp'"/>
  </xsl:call-template>    
  <xsl:copy-of select="$currentmp_index"/>
  <p id="p_header"><a href="mp_index.html">Index</a><xsl:value-of select="' / '"/><xsl:value-of select="$modulename"/> - Module Parameter/Testcase View</p> 
  <div id="div_content">
   <xsl:call-template name="mp_allTables">
    <xsl:with-param name="parameters" select="//element[modulename/text() eq $modulename and @type eq 'parameter']//mpview_ModuleParDef"/>
    <xsl:with-param name="testcases" select="//element[modulename/text() eq $modulename and @type eq 'Testcase']"/>
   </xsl:call-template>
  </div>
 </body>
</html>
 </xsl:result-document>  
<!-- /module mp_view -->


<!-- element -->

 <xsl:for-each select="//element[modulename/text() eq $currentmodule]">
  <xsl:variable name="filename" select="concat('file:///', $folder, '/html/', location/text())"/>
  <xsl:value-of select="$filename"/>
   <xsl:result-document href="{$filename}" format="html">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <xsl:call-template name="html_head">
  <xsl:with-param name="title" select="name/text()"/>
 </xsl:call-template>  
 
 <body onload="init('{@type}'); toggleConstructbodies('{$hideconstructbodies}');">
  <xsl:call-template name="main_allElements">
   <xsl:with-param name="this" select="."/>
   <xsl:with-param name="currentindex" select="$currentindex"/>
  </xsl:call-template>
 </body>
</html>
  </xsl:result-document>
<!-- /element -->
<!-- element TC -->
<xsl:if test="@type eq 'Testcase'">
 <xsl:variable name="filename" select="concat('file:///', $folder, '/html/mp_', location/text())"/>
  <xsl:value-of select="$filename"/>
   <xsl:result-document href="{$filename}" format="html">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <xsl:call-template name="html_head">
  <xsl:with-param name="title" select="name/text()"/>
 </xsl:call-template>  
 <body onload="mp_init('Testcase')">  
  <xsl:call-template name="views">
   <xsl:with-param name="main" select="location/text()"/>
   <xsl:with-param name="mp" select="location/text()"/>
   <xsl:with-param name="togglemode" select="'mp'"/>
  </xsl:call-template>
  <xsl:copy-of select="$currentmp_index"/>
  <p id="p_header">
   <a href="mp_index.html">Index</a> / <a href="{concat('mp_', modulename/text(), '.html')}"><xsl:value-of select="modulename/text()"/></a>
   <xsl:if test="path/path_group">
    <xsl:call-template name="path">
     <xsl:with-param name="this" select="path"/>
     <xsl:with-param name="prefix" select="'mp_'"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:value-of select="' / '"/> <a href="{location/text()}"><xsl:value-of select="name/text()"/></a>
    - Module Parameter/Testcase View
  </p>     
  <div id="div_content">
   <div id="div_mp">
    <xsl:call-template name="mp_testcase_table">
     <xsl:with-param name="this" select="."/>
    </xsl:call-template>
   </div>
  </div>
 </body>
</html>
 </xsl:result-document>
</xsl:if>

<xsl:if test="@type eq 'Module Parameter'">
 <xsl:variable name="filename" select="concat('file:///', $folder, '/html/mp_', location/text())"/>
 <xsl:value-of select="$filename"/>
 <xsl:result-document href="{$filename}" format="html">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <xsl:call-template name="html_head">
  <xsl:with-param name="title" select="name/text()"/>
 </xsl:call-template>  
 <body onload="mp_init('Module Parameter')">
  <xsl:call-template name="views">
   <xsl:with-param name="main" select="location/text()"/>
   <xsl:with-param name="mp" select="location/text()"/>
   <xsl:with-param name="togglemode" select="'mp'"/>
  </xsl:call-template>
  <xsl:copy-of select="$currentmp_index"/>
  <p id="p_header">
   <a href="mp_index.html">Index</a> / <a href="{concat('mp_', modulename/text(), '.html')}"><xsl:value-of select="modulename/text()"/></a>
   <xsl:if test="path/path_group">
    <xsl:call-template name="path">
     <xsl:with-param name="this" select="path"/>
     <xsl:with-param name="prefix" select="'mp_'"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:value-of select="' / '"/> <a href="{location/text()}"><xsl:value-of select="name/text()"/></a>
    - Module Parameter/Testcase View
  </p>
  <div id="div_content">
   <div id="div_mp">
    <xsl:apply-templates select=".//mpview_ModuleParDef"/>
   </div>
  </div>
 </body>
</html>
 </xsl:result-document>
</xsl:if>
 </xsl:for-each>
<!-- /element TC -->
 </xsl:for-each>
<!-- groups -->
 <xsl:for-each select="//group">
  <xsl:variable name="grouplocation" select="location/text()"/>
  <xsl:variable name="group" select="."/>
  <xsl:variable name="filename" select="concat('file:///', $folder, '/html/', location/text())"/>
  <xsl:value-of select="$filename"/>
  <xsl:result-document href="{$filename}" format="html">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <xsl:call-template name="html_head">
  <xsl:with-param name="title" select="name/text()"/>
 </xsl:call-template>
 <body onload="init('Group'); toggleConstructbodies('{$hideconstructbodies}');">
  <xsl:call-template name="views">
   <xsl:with-param name="main" select="./location/text()"/>
   <xsl:with-param name="mp" select="./location/text()"/>
  </xsl:call-template>
  <xsl:call-template name="main_groupindex">
   <xsl:with-param name="grouplocation" select="$grouplocation"/>
  </xsl:call-template>
  <xsl:call-template name="header">
   <xsl:with-param name="this" select="."/>
  </xsl:call-template>        
  <xsl:call-template name="element_withcomment">
   <xsl:with-param name="this" select="."/>
  </xsl:call-template>
 </body>
</html>
  </xsl:result-document>
  
  <xsl:variable name="filename" select="concat('file:///', $folder, '/html/mp_', location/text())"/>
  <xsl:value-of select="$filename"/>
   <xsl:result-document href="{$filename}" format="html">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <xsl:call-template name="html_head">
  <xsl:with-param name="title" select="name/text()"/>
 </xsl:call-template>
 <body onload="mp_init('Group')">
  <xsl:call-template name="views">
   <xsl:with-param name="main" select="./location/text()"/>
   <xsl:with-param name="mp" select="./location/text()"/>
   <xsl:with-param name="togglemode" select="'mp'"/>
  </xsl:call-template>
  <xsl:call-template name="index_modulelist"/>
  <div id="div_index">
   <xsl:call-template name="index_grouplist">
    <xsl:with-param name="this" select="//group[.//path_group[@loc eq $grouplocation]]"/>
    <xsl:with-param name="prefix" select="'mp_'"/>
   </xsl:call-template>

   <xsl:call-template name="index_elementlist">
    <xsl:with-param name="this" select="//element[@type eq 'Module Parameter' and .//path_group[@loc eq $grouplocation]]"/>
    <xsl:with-param name="type" select="'Module Parameter'"/>
    <xsl:with-param name="prefix" select="'mp_'"/>
   </xsl:call-template>
   
   <xsl:call-template name="index_elementlist">
    <xsl:with-param name="this" select="//element[@type eq 'Testcase' and .//path_group[@loc eq $grouplocation]]"/>
    <xsl:with-param name="type" select="'Testcase'"/>
    <xsl:with-param name="prefix" select="'mp_'"/>
   </xsl:call-template>
  </div>
  <xsl:call-template name="header">
   <xsl:with-param name="this" select="."/>
   <xsl:with-param name="prefix" select="'mp_'"/>
  </xsl:call-template>     
  <div id="div_content">
   <xsl:call-template name="mp_allTables">
    <xsl:with-param name="parameters" select="//element[modulename/text() eq $group/modulename/text() and @type eq 'parameter' and .//path_group[@loc eq $group/location/text()]]//mpview_ModuleParDef"/>
    <xsl:with-param name="testcases" select="//element[modulename/text() eq $group/modulename/text() and @type eq 'Testcase' and .//path_group[@loc eq $group/location/text()]]"/>
   </xsl:call-template>
  </div>  
 </body>
</html>
  </xsl:result-document>
 </xsl:for-each>
<!-- /groups -->
</xsl:template>

<xsl:template name="main_allElements">
<xsl:param name="this"/>
<xsl:param name="currentindex"/>
 <xsl:choose>
  <xsl:when test="not($this/@type)">
   <xsl:call-template name="views">
    <xsl:with-param name="main" select="concat($this/name/text(), '.html')"/>
    <xsl:with-param name="mp" select="concat($this/name/text(), '.html')"/>
    <xsl:with-param name="import" select="concat($this/name/text(), '.html')"/>
   </xsl:call-template>  
  </xsl:when>
  <xsl:when test="$this/@type eq 'Testcase' or $this/@type eq 'Module Parameter'">
   <xsl:call-template name="views">
    <xsl:with-param name="main" select="$this/location/text()"/>
    <xsl:with-param name="mp" select="$this/location/text()"/>
   </xsl:call-template> 
  </xsl:when>
  <xsl:otherwise>
   <xsl:call-template name="views">
    <xsl:with-param name="main" select="$this/location/text()"/>
   </xsl:call-template> 
  </xsl:otherwise>
 </xsl:choose>
 <xsl:copy-of select="$currentindex"/>
 <xsl:call-template name="header">
  <xsl:with-param name="this" select="$this"/>
 </xsl:call-template>        
 <xsl:call-template name="element_withcomment">
  <xsl:with-param name="this" select="$this"/>
 </xsl:call-template>
</xsl:template>

<xsl:template name="mp_allTables">
 <xsl:param name="testcases"/>
 <xsl:param name="parameters"/>
 <div id="div_mp">
  <p class="bold"><a href="#mpview_parameters">Module Parameters</a> <a onclick="toggle('mpview_parameters')"> (toggle)</a></p>
  <p class="bold"><a href="#mpview_testcases">Testcases</a> <a onclick="toggle('mpview_testcases')"> (toggle)</a></p>
  <span id="mpview_parameters">
   <p class="bold">Module Parameters:<a name="mpview_parameters"/></p>     
   <xsl:for-each select="$parameters">
    <p>
     <a href="{concat('mp_', @loc)}" id="{@name}"><xsl:value-of select="@name"/></a>
    </p>
    <xsl:apply-templates select="."/>
   </xsl:for-each>     
  </span>
  <span id="mpview_testcases">
   <p class="bold">Testcases:<a name="mpview_testcases"/></p>
   <xsl:for-each select="$testcases">      
    <p><a href="mp_{./location/text()}"><xsl:value-of select="./name/text()"/></a></p>      
    <xsl:call-template name="mp_testcase_table">
     <xsl:with-param name="this" select="."/>
    </xsl:call-template>
   </xsl:for-each>
  </span>
 </div>
</xsl:template>

<xsl:template name="html_head">
<xsl:param name="title"/>
 <head>
  <meta http-equiv="Content-Type" content="text/html;charset=utf-8"/>
  <link rel="stylesheet" type="text/css" href="css/doc.css"/>
   <xsl:choose>
    <xsl:when test="$showOriginalT3DocTags eq 'true'">
     <style type="text/css">
       .span_tagtype{
       	display:none;
      }
     </style>   
    </xsl:when>
    <xsl:otherwise>
     <style type="text/css">
      .span_tagtypeOrig{
       	display:none;
      }
     </style>   
    </xsl:otherwise>
   </xsl:choose>
  <script type="text/javascript" src="js/doc.js"></script>
  <script type="text/javascript" src="js/index.js"></script>
  <title><xsl:value-of select="$title"/></title>
 </head>
</xsl:template>

<xsl:template name="views">
 <xsl:param name="main"/>
 <xsl:param name="mp"/>
 <xsl:param name="import"/>
 <xsl:param name="togglemode"/>
 <div id="div_views">
  <p id="p_views">
   <xsl:choose>
    <xsl:when test="$main">
	 <a href="{$main}">Main View</a> <br/>
	</xsl:when>
	<xsl:otherwise>
	 <a href="index.html">Main View</a> <br/>
	</xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
    <xsl:when test="$mp">
	 <a href="{concat('mp_', $mp)}">Module Parameter/Testcase View</a> <br/>
	</xsl:when>
    <xsl:otherwise>
	 <a href="mp_index.html">Module Parameter/Testcase View</a> <br/>
    </xsl:otherwise>
   </xsl:choose>	 
   <xsl:choose>
    <xsl:when test="$import">
	 <a href="{concat('import_', $import)}">Import  View</a> <br/>
	</xsl:when>
	<xsl:otherwise>
     <a href="import_index.html">Import  View</a> <br/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
	<xsl:when test="$togglemode eq 'mp'">
	 <br/>
	 <a href="#" onclick="togglePaths('true')">toggle paths</a>
	</xsl:when>
	<xsl:when test="$togglemode eq 'import'">
	</xsl:when>
	<xsl:otherwise>
	 <xsl:if test="$includeconstructbodies eq 'true'">
	  <br/>
	  <a href="#" onclick="toggleHideNotes()">show/hide (toggle) notes</a> | <a href="#" onclick="toggleConstructbodies('true')">toggle all</a>
     </xsl:if>  
    </xsl:otherwise>
   </xsl:choose>
  </p>
 </div>
 <p id="p_t3dversion">T3D <xsl:value-of select="/project/@t3dversion"/>
  <br/>Generated <xsl:value-of select="concat(substring-before(string(current-date()), '+'), ' - ', substring-before(string(current-time()), '.'))"/></p>
</xsl:template>

<xsl:template name="main_index">
 <xsl:param name="modulename"/>  
 <xsl:call-template name="index_modulelist"/>
 <div id="div_index">
  <xsl:call-template name="index_grouplist">
   <xsl:with-param name="this" select="//group[$modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_']"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Module Parameter' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'Module Parameter'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Constant' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'Constant'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Type' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'Type'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Signature' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'Signature'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Template' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'Template'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Function' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'Function'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Altstep' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'Altstep'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Testcase' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'Testcase'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'External Function' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'External Function'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'External Constant' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'External Constant'"/>
  </xsl:call-template>
  
 </div>
</xsl:template>

<xsl:template name="mp_index">
 <xsl:param name="modulename"/>
 <xsl:call-template name="index_modulelist">
  <xsl:with-param name="prefix" select="'mp_'"/>
 </xsl:call-template>
 <div id="div_index">
  <xsl:call-template name="index_grouplist">
   <xsl:with-param name="this" select="//group[$modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_']"/>
  <xsl:with-param name="prefix" select="'mp_'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Module Parameter' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'Module Parameter'"/>
  <xsl:with-param name="prefix" select="'mp_'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Testcase' and ($modulename eq modulename/text() or $modulename eq '_T3D_FullIndex_')]"/>
   <xsl:with-param name="type" select="'Testcase'"/>
  <xsl:with-param name="prefix" select="'mp_'"/>
  </xsl:call-template>
 </div>
</xsl:template>

<xsl:template name="index_modulelist">
 <xsl:param name="prefix"/>
 <div id="div_modules">
 <p class="index_headline"><a href="{concat($prefix, 'index.html')}">Module Index</a>
  <xsl:for-each select="//module">
   <xsl:sort select="name/text()"/>
   <br/><a class="padding_left_10px" href="{concat($prefix, name/text())}.html"><xsl:value-of select="name/text()"/></a>  
  </xsl:for-each>
 </p>
 </div>
</xsl:template>

<xsl:template name="header">
 <xsl:param name="this"/>
 <xsl:param name="prefix"/>
 <p id="p_header"><a href="{concat($prefix, 'index.html')}">Index</a><xsl:value-of select="' / '"/>
 <xsl:if test="not($this/name/text() eq $this/modulename/text())"> 
  <a href="{$prefix}{//module[name/text() eq $this/modulename/text()]/name/text()}.html"><xsl:value-of select="//module[name/text() eq $this/modulename/text()]/name/text()"/></a>
 </xsl:if>
 <xsl:if test="$this/path/path_group">
    <xsl:call-template name="path">
     <xsl:with-param name="this" select="$this/path"/>
     <xsl:with-param name="prefix" select="$prefix"/>
    </xsl:call-template>
 </xsl:if>
 
 <xsl:if test="not($this/name/text() eq $this/modulename/text())"><xsl:value-of select="' / '"/></xsl:if> <xsl:value-of select="$this/name/text()"/>
 </p> 
</xsl:template>

<xsl:template name="element_withcomment">
 <xsl:param name="this"/>
 <div id="div_content">
  <xsl:apply-templates select="comment"/>
  <div id="div_element">
   <xsl:apply-templates select="$this/behaviour"/>
  </div>
 </div>
</xsl:template>

<xsl:template name="path">
 <xsl:param name="prefix"/>
 <xsl:param name="this"/>
  <xsl:for-each select="$this/path_group">
   <xsl:call-template name="path_group">
    <xsl:with-param name="this" select="."/>
   <xsl:with-param name="prefix" select="$prefix"/>
  </xsl:call-template>
 </xsl:for-each>
</xsl:template>

<xsl:template name="path_group">
 <xsl:param name="prefix"/>
 <xsl:param name="this"/>
 <xsl:for-each select="$this/path_group">
  <xsl:call-template name="path_group">
   <xsl:with-param name="this" select="."/>
   <xsl:with-param name="prefix" select="$prefix"/>
  </xsl:call-template>
 </xsl:for-each>
 <xsl:value-of select="' / '"/>
 <a href="{concat($prefix, @loc)}"><xsl:value-of select="@name"/></a>
</xsl:template>


<!-- comments -->

<xsl:template match="comment">
 <div id="div_comment">  
 <xsl:if test="desc">
  <p class="comment_headline"><span class="span_tagtype">Description:</span><span class="span_tagtypeOrig">@desc</span><br/>  
   <xsl:apply-templates select="desc"/>
  </p>
 </xsl:if>  
 <xsl:if test="author">
  <p class="comment_headline"><span class="span_tagtype">Author(s):</span><span class="span_tagtypeOrig">@author</span><br/>  
   <xsl:apply-templates select="author"/>
  </p>
 </xsl:if>
 <xsl:if test="config">
  <p class="comment_headline"><span class="span_tagtype">Config:</span><span class="span_tagtypeOrig">@config</span><br/>  
   <xsl:apply-templates select="config"/>
  </p>
 </xsl:if>
 <xsl:if test="exception">
  <p class="comment_headline"><span class="span_tagtype">Exception(s):</span><span class="span_tagtypeOrig">@excepion</span><br/>  
   <xsl:apply-templates select="exception"/>
  </p>
 </xsl:if>
 <xsl:if test="member">
  <p class="comment_headline"><span class="span_tagtype">Member(s):</span><span class="span_tagtypeOrig">@member</span><br/>  
   <xsl:apply-templates select="member"/>
  </p>
 </xsl:if>
 <xsl:if test="param">
  <p class="comment_headline"><span class="span_tagtype">Parameter(s):</span><span class="span_tagtypeOrig">@param</span><br/>  
   <xsl:apply-templates select="param"/>
  </p>
 </xsl:if>
 <xsl:if test="purpose">
  <p class="comment_headline"><span class="span_tagtype">Purpose:</span><span class="span_tagtypeOrig">@purpose</span><br/>  
   <xsl:apply-templates select="purpose"/>
  </p>
 </xsl:if>
 <xsl:if test="remark">
  <p class="comment_headline"><span class="span_tagtype">Remark(s):</span><span class="span_tagtypeOrig">@remark</span><br/>  
   <xsl:apply-templates select="remark"/>
  </p>
 </xsl:if>
 <xsl:if test="return">
  <p class="comment_headline"><span class="span_tagtype">Return:</span><span class="span_tagtypeOrig">@return</span><br/>  
   <xsl:apply-templates select="return"/>
  </p>
 </xsl:if>
 <xsl:if test="see">
  <p class="comment_headline"><span class="span_tagtype">See:</span><span class="span_tagtypeOrig">@see</span><br/>  
   <xsl:apply-templates select="see"/>
  </p>
 </xsl:if>
 <xsl:if test="since">
  <p class="comment_headline"><span class="span_tagtype">Since:</span><span class="span_tagtypeorig">@since</span><br/>  
   <xsl:apply-templates select="since"/>
  </p>
 </xsl:if>
 <xsl:if test="status">
  <p class="comment_headline"><span class="span_tagtype">Status:</span><span class="span_tagtypeOrig">@status</span><br/>  
   <xsl:apply-templates select="status"/>
  </p>
 </xsl:if>
 <xsl:if test="url">
  <p class="comment_headline"><span class="span_tagtype">Url(s):</span><span class="span_tagtypeOrig">@url</span><br/>  
   <xsl:apply-templates select="url"/>
  </p>
 </xsl:if>
 <xsl:if test="verdict">
  <p class="comment_headline"><span class="span_tagtype">Verdict(s):</span><span class="span_tagtypeOrig">@verdict</span><br/>  
   <xsl:apply-templates select="verdict"/>
  </p>
 </xsl:if>
 <xsl:if test="version">
  <p class="comment_headline"><span class="span_tagtype">Version:</span><span class="span_tagtypeOrig">@version</span><br/>  
   <xsl:apply-templates select="version"/>
  </p>
 </xsl:if>
 </div>
</xsl:template>

<xsl:template match="desc | author | return | remark | param | since | status | verdict | version | member | config | exception | purpose | since">
 <xsl:apply-templates/>
 <br/>
</xsl:template>

<xsl:template match="see | esee">
 <xsl:variable name="text" select="normalize-space(text())" />
 <xsl:variable name="modulename" select="''" />
 
 <xsl:if test="self::esee">
  <xsl:value-of select="'@see '"/>
 </xsl:if>
 <xsl:choose>
  <xsl:when test="contains($text, '.')">  
   <xsl:variable name="modulename" select="substring-before($text, '.')"/>
   <xsl:variable name="elementname" select="substring-after($text, '.')"/>
   <xsl:variable name="file" select="//element[name/text() eq $elementname and modulename/text() eq $modulename]"/>
   <xsl:if test="$file">
    <a href="{$file/location/text()}"><xsl:value-of select="$text"/></a>
    <xsl:if test="self::see">
     <br/>
    </xsl:if>
   </xsl:if>
   <xsl:if test="not($file)">
    <xsl:value-of select="$text"/>
    <xsl:if test="self::see">
     <br/>
    </xsl:if>
   </xsl:if>
  </xsl:when>  
  <xsl:otherwise>
   <xsl:variable name="modulename" select="ancestor::module/name/text()"/>
   <xsl:variable name="elementname" select="$text"/>
   <xsl:variable name="file" select="//element[name/text() eq $elementname and modulename/text() eq $modulename]"/>
   <xsl:if test="$file">
    <a href="{$file/location/text()}"><xsl:value-of select="$text"/></a>
    <xsl:if test="self::see">
     <br/>
    </xsl:if>
   </xsl:if>
   <xsl:if test="not($file)">
    <xsl:value-of select="$text"/>
    <xsl:if test="self::see">
     <br/>
    </xsl:if>
   </xsl:if>
  </xsl:otherwise> 
 </xsl:choose>
</xsl:template>

<xsl:template match="eurl">
 <xsl:value-of select="' @url '"/><a href="{text()}"><xsl:value-of select="text()"/></a>
 <xsl:value-of select="' '"/>
</xsl:template>

<xsl:template match="url">
 <a href="{text()}"><xsl:value-of select="text()"/></a>
</xsl:template>
<!-- /comments -->
<!-- behaviour -->

<xsl:template match="behaviour">
 <pre class="statement">
  <xsl:apply-templates/>
 </pre>
</xsl:template>

<xsl:template match="constructbody">
 <span class="span_showhidenote"><a href="#" onclick="toggle('{@id}')">(toggle)</a> </span>
 <span id="{@id}" class="span_constructbody"><xsl:apply-templates/></span>
</xsl:template>

<xsl:template match="keyword">
 <span class="syntax"><xsl:value-of select="text()"/></span>
</xsl:template>

<xsl:template match="link">
 <a href="{@loc}"><xsl:value-of select="replace(replace(text(), ' ', '&#160;'), '\t', '&#x9;')"/></a>
</xsl:template>

<!-- /behaviour -->

<xsl:template name="mp_testcase_table">
 <xsl:param name="this"/>
 <xsl:param name="loc" select="$this/location/text()"/>
    <table border="1">
     <tr><th>Module Parameter</th><th class="td_path">Path</th></tr>
     <xsl:if test="not(//mpview_TestcaseDef[@loc eq $loc])">
      <tr><td>-</td><td>-</td></tr>
     </xsl:if>
     <xsl:for-each select="//mpview_TestcaseDef[@loc eq $loc]">
      <tr><td>
       <a href="{concat('mp_', ancestor::mpview_ModuleParDef/@loc)}"><xsl:value-of select="ancestor::mpview_ModuleParDef/@name"/></a>
      </td>
       <xsl:call-template name="mpview_path_testcase">
        <xsl:with-param name="this" select="."/>
        <xsl:with-param name="first" select="'true'"/>
       </xsl:call-template>
      </tr>
     </xsl:for-each>
    </table>
</xsl:template>

<xsl:template name="mpview_path_testcase">
 <xsl:param name="this"/>
 <xsl:param name="first"/> 
 <xsl:choose>
  <xsl:when test="$first eq 'true'">
   <td class="td_path">
    <xsl:value-of select="' &lt;&lt; '"/>
    <xsl:if test="$this/parent::* and not($this/parent::element)">
     <xsl:call-template name="mpview_path_testcase">
      <xsl:with-param name="this" select="$this/parent::*"/>
      <xsl:with-param name="first" select="'false'"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:value-of select="' &lt;&lt; '"/>
    <a href="{$this/@loc}"><xsl:value-of select="$this/@name"/></a>
   </td>
  </xsl:when>
  <xsl:when test="$this/parent::mpview_ModuleParDef">
   <a href="{$this/@loc}"><xsl:value-of select="$this/@name"/></a>
  </xsl:when>
  <xsl:otherwise>
   <xsl:if test="$this/parent::* and not($this/parent::element)">
    <xsl:call-template name="mpview_path_testcase">
     <xsl:with-param name="this" select="$this/parent::*"/>
     <xsl:with-param name="first" select="'false'"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:value-of select="' &lt;&lt; '"/>
   <a href="{$this/@loc}"><xsl:value-of select="$this/@name"/></a>
  </xsl:otherwise>  
 </xsl:choose>
</xsl:template>

<xsl:template match="mpview_ModuleParDef">
 <xsl:param name="loc" select="@loc"/>
 <xsl:param name="name" select="//element[location/text() eq $loc]/name/text()"/>
 <table border="1">
  <tr>
   <th>Testcase</th> <th class="td_path">Path</th>
  </tr>
  <xsl:if test="not(.//mpview_TestcaseDef)">
   <tr><td>-</td><td class="td_path"></td></tr>
  </xsl:if>
  <xsl:for-each select=".//mpview_TestcaseDef">
   <xsl:sort select="@name"/>
   <tr>
    <xsl:call-template name="mpview_path_modulepar">
     <xsl:with-param name="this" select="."/>
     <xsl:with-param name="first" select="'true'"/>
    </xsl:call-template>
   </tr>
  </xsl:for-each>
 </table>
</xsl:template>

<xsl:template name="mpview_path_modulepar">
 <xsl:param name="this"/>
 <xsl:param name="first"/> 
 <xsl:choose>
  <xsl:when test="$first eq 'true'">
   <td>
    <a href="{concat('mp_', $this/@loc)}"><xsl:value-of select="$this/@name"/></a>
   </td>
   <td class="td_path">
    <xsl:if test="$this/parent::* and not($this/parent::element)">
     <xsl:call-template name="mpview_path_modulepar">
      <xsl:with-param name="this" select="$this/parent::*"/>
      <xsl:with-param name="first" select="'false'"/>
     </xsl:call-template>
    </xsl:if>   
   </td>
  </xsl:when>
  <xsl:otherwise>
   <xsl:value-of select="' &gt;&gt; '"/>
   <a href="{$this/@loc}"><xsl:value-of select="$this/@name"/></a>
    <xsl:if test="$this/parent::* and not($this/parent::element)">
    <xsl:call-template name="mpview_path_modulepar">
     <xsl:with-param name="this" select="$this/parent::*"/>
     <xsl:with-param name="first" select="'false'"/>
    </xsl:call-template>
   </xsl:if>
  </xsl:otherwise>  
 </xsl:choose>
</xsl:template>

<xsl:template name="main_groupindex">
 <xsl:param name="grouplocation"/>
 <xsl:call-template name="index_modulelist"/>
 <div id="div_index">
  <xsl:call-template name="index_grouplist">
   <xsl:with-param name="this" select="//group[.//path_group[@loc eq $grouplocation]]"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Module Parameter' and .//path_group[@loc eq $grouplocation]]"/>
   <xsl:with-param name="type" select="'Module Parameter'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Constant' and .//path_group[@loc eq $grouplocation]]"/>
   <xsl:with-param name="type" select="'Constant'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Type' and .//path_group[@loc eq $grouplocation]]"/>
   <xsl:with-param name="type" select="'Type'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Signature' and .//path_group[@loc eq $grouplocation]]"/>
   <xsl:with-param name="type" select="'Signature'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Template' and .//path_group[@loc eq $grouplocation]]"/>
   <xsl:with-param name="type" select="'Template'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Function' and .//path_group[@loc eq $grouplocation]]"/>
   <xsl:with-param name="type" select="'Function'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Altstep' and .//path_group[@loc eq $grouplocation]]"/>
   <xsl:with-param name="type" select="'Altstep'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'Testcase' and .//path_group[@loc eq $grouplocation]]"/>
   <xsl:with-param name="type" select="'Testcase'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'External Function' and .//path_group[@loc eq $grouplocation]]"/>
   <xsl:with-param name="type" select="'External Function'"/>
  </xsl:call-template>
  <xsl:call-template name="index_elementlist">
   <xsl:with-param name="this" select="//element[@type eq 'External Constant' and .//path_group[@loc eq $grouplocation]]"/>
   <xsl:with-param name="type" select="'External Constant'"/>
  </xsl:call-template>
 </div>
</xsl:template>

<xsl:template name="index_grouplist">
 <xsl:param name="this"/>
 <xsl:param name="prefix"/>
  <p class="index_headline"><a href="#" onclick="toggle('span_groups')">Groups</a>
   <span id="span_groups">
    <xsl:if test="not($this)">
     <br/><span class="padding_left_10px"><xsl:value-of select="'-'"/></span>
    </xsl:if>
    <xsl:for-each select="$this">
     <xsl:sort select="name/text()"/>
     <br/><a class="padding_left_10px" href="{concat($prefix, location/text())}"><xsl:value-of select="name/text()"/></a>
    </xsl:for-each>
   </span>
  </p>
</xsl:template>

<xsl:template name="index_elementlist">
 <xsl:param name="this"/>
 <xsl:param name="type"/>
 <xsl:param name="prefix"/>
 <p class="index_headline"><a href="#" onclick="toggle('span_{lower-case($type)}s')"><xsl:value-of select="$type"/>s</a>
 <span id="span_{lower-case($type)}s">
  <xsl:if test="not($this)">
   <br/><span class="padding_left_10px"><xsl:value-of select="'-'"/></span>
  </xsl:if>
  <xsl:for-each select="$this">
  <xsl:sort select="name/text()"/>
   <br/><a class="padding_left_10px" href="{concat($prefix, location/text())}"><xsl:value-of select="name/text()"/></a>
  </xsl:for-each>
 </span>
 </p>
</xsl:template>
</xsl:stylesheet>