#include "Logger.h"
#include <iostream>

Logger::Logger(void)
{
  m_nLogMode = LOG_ALL;
}

Logger::~Logger(void)
{
}

void Logger::LogLine(const std::string sText)
{
  boost::mutex::scoped_lock lock(m_mutex);
  std::clog << sText << std::endl;
}

void Logger::LogInfo(const std::string sInfo)
{
  if ((m_nLogMode & LOG_INFO) != 0)
    LogLine(sInfo);
}
void Logger::LogError(const std::string sError)
{
  if ((m_nLogMode & LOG_ERRORS) != 0)
    LogLine(sError);
}
void Logger::LogWarning(const std::string sWarning)
{
  if ((m_nLogMode & LOG_WARNINGS) != 0)
    LogLine(sWarning);
}

void Logger::LogCapture(const std::string sData)
{
  if ((m_nLogMode & LOG_CAPTURE) != 0)
    LogLine(sData);
}

void Logger::LogDebug(const std::string sDebugInfo)
{
  if ((m_nLogMode & LOG_DEBUG) != 0)
    LogLine(sDebugInfo);
}
