#include "ProtocolInfo.h"

ProtocolInfoElement::ProtocolInfoElement()
{
}
ProtocolInfoElement::~ProtocolInfoElement()
{
}
bool ProtocolInfoElement::Match (const ProtocolInfoElement & toCompare) const
{
	return GetId() == toCompare.GetId();
}

ProtocolInfo::ProtocolInfo()
{
}

ProtocolInfo::~ProtocolInfo()
{
	int nLen = size();
	for (int i = 0; i < nLen; ++i)
		delete (*this)[i];
}
void ProtocolInfo::AddItem(ProtocolInfoElement * info)
{
	push_back(info);
}

bool ProtocolInfo::Match(ProtocolInfo & info) const
{
	size_t nLen = size();
	if (nLen != info.size())
		return false;
	for (unsigned int i = 0; i < nLen; ++i)
		if (!(*this)[i]->Match(*info[i]))
			return false;
	return true;
}

size_t ProtocolInfo::Count()
{
	return size();
}
const ProtocolInfoElement * ProtocolInfo::operator[] ( int nIndex ) const
{
	return std::vector<ProtocolInfoElement *>::operator[](nIndex);
}


IPv4Info::IPv4Info() :
	m_nSrcAddr(0),
	m_nDstAddr(0)
{
}

IPv4Info::IPv4Info(const IPv4Info & src) :
	m_nSrcAddr(src.m_nSrcAddr),
	m_nDstAddr(src.m_nDstAddr)
{
}

IPv4Info::~IPv4Info()
{
}
bool IPv4Info::Match (const ProtocolInfoElement & toCompare) const
{
	if (!ProtocolInfoElement::Match(toCompare))
		return false;
	const IPv4Info & tmp = dynamic_cast<const IPv4Info &>(toCompare);
	return m_nSrcAddr == tmp.m_nSrcAddr && m_nDstAddr == tmp.m_nDstAddr;
}

ProtocolInfoElement * IPv4Info::Clone() const
{
	return new IPv4Info(*this);
}

TransportLayerInfo::TransportLayerInfo() :
	m_nSrcPort(0),
	m_nDstPort(0)
{
}

TransportLayerInfo::TransportLayerInfo(const TransportLayerInfo & src) :
	m_nSrcPort(src.m_nSrcPort),
	m_nDstPort(src.m_nDstPort)
{
}

TransportLayerInfo::~TransportLayerInfo()
{
}
bool TransportLayerInfo::Match (const ProtocolInfoElement & toCompare) const
{
	if (!ProtocolInfoElement::Match(toCompare))
		return false;
	const TransportLayerInfo & tmp = dynamic_cast<const TransportLayerInfo &>(toCompare);
	return m_nSrcPort == tmp.m_nSrcPort && m_nDstPort == tmp.m_nDstPort;
}

TcpInfo::TcpInfo() 
{
}

TcpInfo::TcpInfo(const TcpInfo & src) :
	TransportLayerInfo(src)
{
}

TcpInfo::~TcpInfo()
{
}

ProtocolInfoElement * TcpInfo::Clone() const
{
	return new TcpInfo(*this);
}


UdpInfo::UdpInfo() 
{
}

UdpInfo::UdpInfo(const UdpInfo & src) :
	TransportLayerInfo(src)
{
}

UdpInfo::~UdpInfo()
{
}

ProtocolInfoElement * UdpInfo::Clone() const
{
	return new UdpInfo(*this);
}

