/**
 * @file PCAPOfflineCapture.cpp
 * @author Tomas Urban
 * @version 0.4
 * @date 23/07/2009
 */
#include "PCAPOfflineCapture.h"
#include "Logger/Logger.h"

PCAPOfflineCapture::PCAPOfflineCapture()
{
}

PCAPOfflineCapture::~PCAPOfflineCapture(void)
{
}

ECaptureInitResult PCAPOfflineCapture::OpenDevice(const std::string sParams)
{
	CloseDevice();
	char errbuf[PCAP_ERRBUF_SIZE];
	char source[PCAP_BUF_SIZE];

	if ( pcap_createsrcstr( source, PCAP_SRC_FILE, NULL, NULL, sParams.c_str(), errbuf) != 0)
		return ECaptureInit_Failed;

	pcap_t * fp = OpenPcapSource(source);
	if (!fp)
		return ECaptureInit_Failed;

	pcap_pkthdr header;
	if (pcap_next(fp, &header))
		SetStartPoint(header.ts);
	pcap_close(fp);
	fp = OpenPcapSource(source);
	

	SetPcapHandles(&fp, 1);
	return ECaptureInit_Successful;
}
