#ifndef STF370_Socket_h
#define STF370_Socket_h

#include <string>

#define MAX_CLIENTS 10
	
class Socket {

 public:
  Socket() throw (std::string);
  Socket(const int socket);
  int Send(const char *data, const int length) throw (std::string);
  int Receive(const ssize_t buf_len, char * buf) throw (std::string);
  virtual ~Socket();

 protected:
  int m_socket;

 private:

#ifdef WIN32
  static int m_nbSockets;
#endif

};



class SocketClient : public Socket {

 public:
  SocketClient(const std::string &host, const int port) throw (std::string);

};



class SocketServer : public Socket {

 public:
  SocketServer(const int port) throw (std::string);
  Socket* Accept() throw (std::string);

};


#endif
