#ifndef DISPATCHER_H
#define DISPATCHER_H

#include <map>
#include <list>
#include <string>

#include "Dissector.h"
#include "DispatchInfo.h"
#include "Filter.h"

class Dispatcher {

 public:
  Dispatcher(std::string sName="");
  virtual ~Dispatcher();
  virtual bool Dispatch(DispatchInfo & info, ComponentFilter & filter);
  virtual void AddExplicitUpperLayer(EProtocolType sUpperLayer);

 protected:
  virtual const std::string& GetName() const;
  std::string m_sName;
  std::list<Dissector *> m_fragments;
  std::list<Dispatcher *> m_upperLayers;
  
};

#endif
