/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xom;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import net.sf.saxon.xom.DocumentWrapper;
import nu.xom.Document;
import nu.xom.Node;

public class XOMObjectModel
implements ExternalObjectModel,
Serializable {
    public String getIdentifyingURI() {
        return "http://www.xom.nu/jaxp/xpath/xom";
    }

    public PJConverter getPJConverter(Class targetClass) {
        if (this.isRecognizedNodeClass(targetClass)) {
            return new PJConverter(){

                public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
                    return XOMObjectModel.this.convertXPathValueToObject(Value.asValue((ValueRepresentation)value), targetClass, context);
                }
            };
        }
        return null;
    }

    public JPConverter getJPConverter(Class targetClass) {
        if (this.isRecognizedNodeClass(targetClass)) {
            return new JPConverter(){

                public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
                    return XOMObjectModel.this.convertObjectToXPathValue(object, context.getConfiguration());
                }

                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        return null;
    }

    public PJConverter getNodeListCreator(Object node) {
        return null;
    }

    public boolean isRecognizedNode(Object object) {
        return object instanceof Node;
    }

    public boolean isRecognizedNodeClass(Class nodeClass) {
        return Node.class.isAssignableFrom(nodeClass);
    }

    public boolean isRecognizedNodeListClass(Class nodeClass) {
        return false;
    }

    public Receiver getDocumentBuilder(Result result) {
        return null;
    }

    public boolean sendSource(Source source, Receiver receiver, PipelineConfiguration pipe) throws XPathException {
        return false;
    }

    public NodeInfo unravel(Source source, Configuration config) {
        return null;
    }

    public ValueRepresentation convertObjectToXPathValue(Object object, Configuration config) throws XPathException {
        if (object instanceof Node) {
            return this.wrapNode((Node)object, config);
        }
        if (object instanceof Node[]) {
            NodeInfo[] nodes = new NodeInfo[((Node[])object).length];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = this.wrapNode(((Node[])object)[i], config);
            }
            return new SequenceExtent((Item[])nodes);
        }
        return null;
    }

    private synchronized NodeInfo wrapNode(Node node, Configuration config) {
        return new DocumentWrapper((Node)node.getDocument(), "", config).wrap(node);
    }

    public Object convertXPathValueToObject(Value value, Object targetClass, XPathContext context) throws XPathException {
        Item item;
        boolean allowXOM;
        Class target;
        boolean requireXOM = Node.class.isAssignableFrom(target = (Class)targetClass) || target.isArray() && Node.class.isAssignableFrom(target.getComponentType());
        boolean bl = target == Object.class || target.isAssignableFrom(ArrayList.class) || target.isAssignableFrom(HashSet.class) || target.isArray() && target.getComponentType() == Object.class ? true : (allowXOM = false);
        if (!requireXOM && !allowXOM) {
            return null;
        }
        ArrayList<Object> nodes = new ArrayList<Object>(20);
        SequenceIterator iter = value.iterate();
        while ((item = iter.next()) != null) {
            if (item instanceof VirtualNode) {
                Object o = ((VirtualNode)item).getUnderlyingNode();
                if (o instanceof Node) {
                    nodes.add(o);
                    continue;
                }
                if (!requireXOM) continue;
                XPathException err = new XPathException("Extension function required class " + target.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
                throw err;
            }
            if (requireXOM) {
                XPathException err = new XPathException("Extension function required class " + target.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
                throw err;
            }
            return null;
        }
        if (nodes.isEmpty() && !requireXOM) {
            return null;
        }
        if (Node.class.isAssignableFrom(target)) {
            if (nodes.size() != 1) {
                XPathException err = new XPathException("Extension function requires a single XOM Node; supplied value contains " + nodes.size() + " nodes");
                throw err;
            }
            return nodes.get(0);
        }
        if (target.isArray() && Node.class.isAssignableFrom(target.getComponentType())) {
            Node[] array = (Node[])Array.newInstance(target.getComponentType(), nodes.size());
            nodes.toArray(array);
            return array;
        }
        if (target.isAssignableFrom(ArrayList.class)) {
            return nodes;
        }
        if (target.isAssignableFrom(HashSet.class)) {
            return new HashSet(nodes);
        }
        return null;
    }

    public DocumentInfo wrapDocument(Object node, String baseURI, Configuration config) {
        Document documentNode = ((Node)node).getDocument();
        return new DocumentWrapper((Node)documentNode, baseURI, config);
    }

    public NodeInfo wrapNode(DocumentInfo document, Object node) {
        if (!(node instanceof Node)) {
            throw new IllegalArgumentException("Object to be wrapped is not a XOM Node: " + node.getClass());
        }
        return ((DocumentWrapper)document).wrap((Node)node);
    }
}

