#ifndef Processors_TriggerCommandsStrategy_h
#define Processors_TriggerCommandsStrategy_h

#include <string>
#include <vector>

#include "Helper/GeneralConfigurationParams.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
/*! Class TriggerCommandsStrategy
 * \brief .
 */
class TriggerCommandsStrategy
{
public:
  TriggerCommandsStrategy() {};
  virtual ~TriggerCommandsStrategy() {}
public: // Public interface.
  //! define the behavior of the human friendly application 'UEUserGuide'.
  enum Strategies {
    UEUserGuide, //! Human friendly application.
    UEOffLine, //! Offline behavior.
    UEError //! Unsupported strategies.
  };
  
  enum UserActions {
        // Summary:
        //     Nothing is returned from the dialog box. This means that the modal dialog
        //     continues running.
        ButtonNone = 0,
        //
        // Summary:
        //     The dialog box return value is OK (usually sent from a button labeled OK).
        ButtonOk = 1,
        //
        // Summary:
        //     The dialog box return value is Cancel (usually sent from a button labeled
        //     Cancel).
        ButtonCancel = 2,
        //
        // Summary:
        //     The dialog box return value is Abort (usually sent from a button labeled
        //     Abort).
        ButtonAbort = 3,
        //
        // Summary:
        //     The dialog box return value is Retry (usually sent from a button labeled
        //     Retry).
        ButtonRetry = 4,
        //
        // Summary:
        //     The dialog box return value is Ignore (usually sent from a button labeled
        //     Ignore).
        ButtonIgnore = 5,
        //
        // Summary:
        //     The dialog box return value is Yes (usually sent from a button labeled Yes).
        ButtonYes = 6,
        //
        // Summary:
        //     The dialog box return value is No (usually sent from a button labeled No).
        ButtonNo = 7,
  };
  //! SetEutIpInterface.
  /*! Initialize the EUT IP interface.
   * @param iface: .EUT IP interface.
   */
  virtual void SetEutIpInterface(boost::shared_ptr<EutIPInterface> iface) {};
  //! Process.
  /*! Process the Trigger command message.
   * @param command: trigger command to execute
   * @param params: Comand parameters
   * @return FncRetCode value on success, -1 otherwise.
   */
  virtual int Process(const std::string &trigger, const std::vector<std::string> &parameterList) { return -1; };
};

} } // namespaces

#endif // Processors_TriggerCommandsStrategy_h

