/**
 * @file ConnectionController.h
 * This header file defines the TcpipServer class.
 * @author Tomas Urban
 * @version 0.2
 * @date 23/07/2009
 */
#ifndef CONNECTION_CONTROLLER_H
#define CONNECTION_CONTROLLER_H

#include "TcpipDefs.h"
#include "GenericCapture.h"
#include "Messages/TrafficCaptureMessage.h"
#include "TcpipDispatch.h"
#include <boost/thread/mutex.hpp>
#include <boost/thread/condition.hpp>

/**
 * ConnectionController is class which handles a single client TCP/IP connection. It reads requests from
 * the client, decodes and processes them and replies to them if needed.
 */
class ConnectionController
{
private:
	SOCKET_TYPE m_hSocket;
	GenericCapture * m_pCapture;
	boost::mutex m_mutex;
	boost::condition m_captureClosed;
	void SendSimpleReply(CommonReplyMessage & reply, bool bRes);
	void ProcessMessage(const struct TMessageHeader & header, const char * pPayload, TcpipDispatch & td);
public:
	/**
	 * Class constructor.
	 * @param hSocket Handle to client's socket
	 */
	ConnectionController(SOCKET_TYPE hSocket);
	~ConnectionController(void);
	/**
	 * The method starts waiting for client's requests and processing them. It is a blocking method
	 * and it returns only if the connection is interrupted or on client's request to terminate the whole
	 * session.
	 */
	void Run();
	/**
	 * The method is used for stopping a running connection controller.
	 */
	void Stop();
};

#endif
