#ifndef SIP_DISSECTOR_H
#define SIP_DISSECTOR_H

#include "Dissector.h"
#include <string>

class SipDissector : public Dissector {

 public:
  SipDissector();
  virtual ~SipDissector();
  virtual SipDissector * Clone() const;
  virtual bool Dissect(const unsigned char * pData, const ssize_t nDataLen);
  virtual bool NeedReassembly() const;
  virtual bool Reassemble(Dissector * pDissector, ProtocolInfo * pProtocolInfo);
  virtual const EProtocolType GetUpperLayerType() const;
  virtual bool IsPacketValid() const;
  virtual bool FinishDissection();
  virtual bool CreatesUnprocessedData() const;
 protected:
  ProtocolInfoElement * CreateLayerInfo();
 private:
  static const int HEADER_NOT_PARSED = -1;
  static const int LENGTH_NOT_PARSED = -2;
  static const int PARSING_ERROR = -3;
  int m_nMessageLength;
};

#endif
