#include "DispatchInfo.h"

DispatchInfo::DispatchInfo() 
  : m_pData(0),
    m_nDataSize(0),
	m_pProtocolInfo(0)
{
}

DispatchInfo::~DispatchInfo() 
{
	delete [] m_pData;
	delete m_pProtocolInfo;
}

const unsigned char * DispatchInfo::GetData() const {
  return m_pData;
}

const ssize_t DispatchInfo::GetDataSize() const {
  return m_nDataSize;
}

void DispatchInfo::SetData(const unsigned char * pData, const ssize_t nDataSize)
{
	delete [] m_pData;
	if (nDataSize > 0)
	{
		m_pData = new unsigned char[nDataSize];
		memcpy(m_pData, pData, nDataSize);
		m_nDataSize = nDataSize;
	}
	else
	{
		m_pData = 0;
		m_nDataSize = 0;
	}
}

void DispatchInfo::AddProtocolInfo(ProtocolInfoElement * info)
{
	if (!m_pProtocolInfo)
		m_pProtocolInfo = new ProtocolInfo();
	m_pProtocolInfo->AddItem(info);
}

ProtocolInfo * DispatchInfo::DetachProtocolInfo()
{
	ProtocolInfo * pRes = m_pProtocolInfo;
	m_pProtocolInfo = 0;
	return pRes;
}

ProtocolInfo * DispatchInfo::GetProtocolInfo() const
{
	return m_pProtocolInfo;
}
