package de.ugoe.cs.swe.trex.core.analyzer.rfparser;

import java.io.IOException;
import java.io.Writer;

import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import de.ugoe.cs.swe.trex.core.analyzer.rfparser.symboltable.Scope;
import de.ugoe.cs.swe.trex.core.analyzer.rfparser.symboltable.Symbol;

public class LocationAST extends CommonAST implements Comparable<LocationAST> {

	private static final long serialVersionUID = 1L;

	protected int offset = -1;

	protected int endOffset = -1;

	private LocationAST mParent;

	private transient Token token;

	private transient Scope scope = null;

	private transient Scope childScope = null;

	private int line = -1;

	private int endLine = -1;

	protected TokenWithIndex hiddenBefore, hiddenAfter;

	// ---------------------------------------------------------------------------

	public LocationAST() {
		super();
	}

	// ---------------------------------------------------------------------------

	public int getEndOffset() {
		return endOffset;
	}

	// ---------------------------------------------------------------------------

	public void setEndOffset(int endOffset) {
		this.endOffset = endOffset;
	}

	// ---------------------------------------------------------------------------

	public int getOffset() {
		return offset;
	}

	// ---------------------------------------------------------------------------

	public void setOffset(int offset) {
		this.offset = offset;
	}

	// ---------------------------------------------------------------------------

	public int getEndLine() {
		return endLine;
	}

	// ---------------------------------------------------------------------------

	public Scope getScope() {
		return scope;
	}

	// ---------------------------------------------------------------------------

	public void setScope(Scope scope) {
		this.scope = scope;
	}

	// ---------------------------------------------------------------------------

	public LocationAST(Token tok) {
		super(tok);
		initialize(tok);
	}

	// ---------------------------------------------------------------------------

	@Override
	public void initialize(int t, String txt) {
		setType(t);
		setText(txt);
	}

	// ---------------------------------------------------------------------------

	public void initialize(AST t)
	{
		hiddenBefore = ((TokenWithIndex)t).getHiddenBefore();
		hiddenAfter = ((TokenWithIndex)t).getHiddenAfter();
		super.initialize(t);
	}

	// ---------------------------------------------------------------------------

	@Override
	public void initialize(Token tok) {
		if (tok == null) {
			return;
		}
		setText(tok.getText());
		setType(tok.getType());

		if (tok instanceof TokenWithIndex) {
			TokenWithIndex tokIndex = (TokenWithIndex) tok;
			if (tokIndex.getType() == TTCN3LexerTokenTypes.CSTRING) {
				offset = (tokIndex.getOffset() - 2 - tokIndex.getText()
						.length());
				endOffset = (tokIndex.getOffset());
				line = tokIndex.getLine();
			} else if ((tokIndex.getType() == TTCN3LexerTokenTypes.BSTRING)
					|| (tokIndex.getType() == TTCN3LexerTokenTypes.HSTRING)
					|| (tokIndex.getType() == TTCN3LexerTokenTypes.OSTRING)
					|| (tokIndex.getType() == TTCN3LexerTokenTypes.BSTRINGMATCH)
					|| (tokIndex.getType() == TTCN3LexerTokenTypes.OSTRINGMATCH)
					|| (tokIndex.getType() == TTCN3LexerTokenTypes.HSTRINGMATCH)) {
				offset = (tokIndex.getOffset() - 3 - tokIndex.getText()
						.length());
				endOffset = (tokIndex.getOffset());
				line = tokIndex.getLine();
			}

			else {
				if (tokIndex.getText() != null) {
					offset = (tokIndex.getOffset() - tokIndex.getText().length());
				}
				endOffset = (tokIndex.getOffset());
				line = tokIndex.getLine();
			}

			hiddenBefore = ((TokenWithIndex)tok).getHiddenBefore();
			hiddenAfter = ((TokenWithIndex)tok).getHiddenAfter();
		}

		this.token = tok;
	}

	// ---------------------------------------------------------------------------

	public boolean isImaginaryNode() {
		return (token == null);
	}

	// ---------------------------------------------------------------------------

	@Override
	public int getType() {
		if (token == null)
			return super.getType();

		return token.getType();
	}

	// ---------------------------------------------------------------------------

	public Token getToken() {
		return token;
	}

	// ---------------------------------------------------------------------------

	public LocationAST getNthChild(int depth) {
		if (depth > 1) {
			return getFirstChild().getNthChild(depth - 1);
		}
		return getFirstChild();
	}

	// ---------------------------------------------------------------------------

	public LocationAST getNthParent(int depth) {
		if (depth > 1) {
			return getParent().getNthParent(depth - 1);
		}
		return getParent();
	}

	// ---------------------------------------------------------------------------

	public boolean existsNthChild(int depth) {
		if (depth > 1) {
			if (getFirstChild() != null)
				return getFirstChild().existsNthChild(depth - 1);
			else
				return false;
		}
		if (getFirstChild() != null)
			return true;
		else
			return false;
	}

	// ---------------------------------------------------------------------------

	@Override
	public void setFirstChild(AST anAST) {
		if (anAST == null) {
			super.setFirstChild(null);
		} else {
			LocationAST myAST = (LocationAST) anAST;
			myAST.setParent(this);
			super.setFirstChild(myAST);
		}
	}

	// ---------------------------------------------------------------------------

	@Override
	public void setNextSibling(AST anAST) {
		if (anAST == null) {
			super.setNextSibling(null);
		} else {
			LocationAST myAST = (LocationAST) anAST;
			myAST.setParent(mParent);
			super.setNextSibling(myAST);
		}
	}

	// ---------------------------------------------------------------------------

	@Override
	public void addChild(AST anAST) {
		if (anAST == null) {
			super.addChild(null);
		} else {
			LocationAST myAST = (LocationAST) anAST;
			myAST.setParent(this);
			super.addChild(myAST);
		}
	}

	// ---------------------------------------------------------------------------

	public void setLocation(LocationAST mtok) {
		try {
			offset = mtok.getOffset();
			line = mtok.getLine();
		} catch (NullPointerException nex) {
			return;
		}
	}

	// ---------------------------------------------------------------------------

	public void setEndLocation(LocationAST tok) {
		if (tok == null)
			return;

		try {
			endOffset = tok.getEndOffset();
			endLine = tok.getLine();
		} catch (NullPointerException nex) {
			return;
		}
	}

	// ---------------------------------------------------------------------------

	public void setLocation(LocationAST startTok, LocationAST endTok) {
		if (startTok == null || endTok == null)
			return;

		try {
			offset = startTok.getOffset();
			line = startTok.getLine();
			endOffset = endTok.getEndOffset();
			endLine = endTok.getLine();
		} catch (NullPointerException nex) {
			return;
		}
	}

	// ---------------------------------------------------------------------------

	@Override
	public String toString() {
		// return "[" + getText() + "," + getLine() + ":" + getColumn() + "]";
		if (this.getType() == TTCN3LexerTokenTypes.IDENTIFIER) {
			return getText() + " (Line: " + getLine() + ")";
		}

		if (isImaginaryNode()) {
			return super.toString() + "[L/AST:imaginary]" + "[startOfs: "
					+ getOffset() + ", endOfs: " + getEndOffset() + ", line: "
					+ getLine() + "]";
		}

		return super.toString() + "[L/AST]" + "[startOfs: " + getOffset()
				+ ", endOfs: " + getEndOffset() + ", line: " + getLine() + "]";
	}

	// ---------------------------------------------------------------------------

	private void setParent(LocationAST aParent) {
		mParent = aParent;
		LocationAST nextSibling = this.getNextSibling();
		while (nextSibling != null) {
			nextSibling.mParent = aParent;
			nextSibling = nextSibling.getNextSibling();
		}
	}

	// ---------------------------------------------------------------------------

	public LocationAST getParent() {
		return mParent;
	}

	// ---------------------------------------------------------------------------

	@Override
	public boolean equals(AST t) {
		boolean superResult = super.equals(t);
		boolean thisResult = false;
		if ((t.getLine() == this.getLine())
				&& (t.getColumn() == this.getColumn()))
			thisResult = true;

		return superResult && thisResult;
	}

	// ---------------------------------------------------------------------------

	public static boolean isOfType(LocationAST node, int type) {
		if (node.getType() == type)
			return true;

		return false;
	}

	// ---------------------------------------------------------------------------

	public static boolean isOfType(LocationAST node, int[] type) {
		for (int element : type) {
			if (node.getType() == element)
				return true;
		}
		return false;
	}

	// ---------------------------------------------------------------------------

	public static LocationAST resolveParentsUntilType(LocationAST node,
			int[] type) {
		LocationAST match = node;

		while (match != null) {
			if (LocationAST.isOfType(match, type)) {
				return match;
			}
			match = match.getParent();
		}

		return null;
	}

	// ---------------------------------------------------------------------------

	public static LocationAST resolveParentsUntilType(LocationAST node, int type) {
		LocationAST match = node;

		while (match != null) {
			if (LocationAST.isOfType(match, type)) {
				return match;
			}
			match = match.getParent();
		}

		return null;
	}

	// ---------------------------------------------------------------------------

	public static boolean isExtendedReference(LocationAST t) {
		if (t == null)
			return false;

		if (t.getParent() == null)
			return false;

		if (t.getParent().getParent() == null)
			return false;

		LocationAST node = t.getParent().getParent();

		if ((node.getType() == TTCN3LexerTokenTypes.ExtendedFieldReference)
				|| (node.getType() == TTCN3LexerTokenTypes.ValueReference))
			return true;

		return false;
	}

	// ---------------------------------------------------------------------------

	public static boolean isPortReference(LocationAST t) {
		if (t == null)
			return false;

		if (t.getParent() == null)
			return false;

		if (t.getParent().getParent() == null)
			return false;

		LocationAST node = t.getParent().getParent();

		if (node.getType() == TTCN3LexerTokenTypes.Port)
			return true;

		return false;
	}

	// ---------------------------------------------------------------------------

	public static boolean isFieldReference(LocationAST t) {
		if (t == null)
			return false;

		if (t.getParent() == null)
			return false;

		if (t.getParent().getParent() == null)
			return false;

		LocationAST node = t.getParent().getParent();

		if (node.getType() == TTCN3LexerTokenTypes.FieldReference)
			return true;

		return false;
	}

	// ---------------------------------------------------------------------------

	public static boolean isEnumeratedValue(LocationAST t) {
		if (t == null)
			return false;

		if (t.getParent() == null)
			return false;

		if (t.getParent().getParent() == null)
			return false;

		LocationAST node = t.getParent().getParent();

		if (node.getType() == TTCN3LexerTokenTypes.EnumeratedValue) {
			LocationAST test = LocationAST.resolveParentsUntilType(node,
					new int[] { TTCN3LexerTokenTypes.FieldSpec,
							TTCN3LexerTokenTypes.Assignment });
			if (test != null)
				return true;
		}

		return false;
	}

	// ---------------------------------------------------------------------------

	public Scope getChildScope() {
		return childScope;
	}

	// ---------------------------------------------------------------------------

	public void setChildScope(Scope childScope) {
		this.childScope = childScope;
	}

	// ---------------------------------------------------------------------------

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(LocationAST arg0) {
		return this.getText().compareTo(arg0.getText());
	}

	// ---------------------------------------------------------------------------

	@Override
	public int getLine() {
		return line;
	}

	// ---------------------------------------------------------------------------

	@Override
	public LocationAST getNextSibling() {
//		return (LocationAST) super.getNextSibling();
		return (LocationAST) right;
	}

	// ---------------------------------------------------------------------------

	@Override
	public LocationAST getFirstChild() {
//		return (LocationAST) super.getFirstChild();
		return (LocationAST) down;
	}

	// ---------------------------------------------------------------------------

	@Override
	public int hashCode() {
		int hash = 11;
		hash = 31 * hash + offset;
		hash = 31 * hash + endOffset;
		hash = 31 * hash + ((token == null) ? super.getType() : token.getType());
		return hash;
	}

	// ---------------------------------------------------------------------------

	public Symbol getSymbol() {
		return getScope().resolve(this);
	}

	// ---------------------------------------------------------------------------

	public TokenWithIndex getHiddenAfter() {
		return hiddenAfter;
	}

	// ---------------------------------------------------------------------------

	public TokenWithIndex getHiddenBefore() {
		return hiddenBefore;
	}

	// ---------------------------------------------------------------------------

	private static boolean bXMLPrintNewline = false;
	private static boolean bXMLIndentThisLine = true;
	private static boolean bXMLIndent = false;

	private void xmlFormat(Writer stream, long depth) throws IOException {
		if (bXMLPrintNewline)
				stream.write("\n");

		// indentation bloats XML and makes the generation slow!
		if (bXMLIndent && bXMLIndentThisLine)
			for (long i = 0; i < depth; i++)
				stream.write(" ");

		bXMLPrintNewline = bXMLIndentThisLine = true;
	}

	private String xmlAddAttribute(String name, Object value) {
		return " " + name + "=\"" + value.toString() + "\"";
	}

	private void xmlSerializeTextNode(Writer stream, long depth)
		throws IOException 
	{
		stream.write(encode(getText()));
		bXMLPrintNewline = bXMLIndentThisLine = false;
	}

	private void xmlSerializeElementOpen(Writer stream, long depth, String fileName)
		throws IOException
	{
		xmlFormat(stream, depth);
		stream.write("<" + encode(getText()));
		if (depth == 1)
			stream.write(xmlAddAttribute("filename", encode(fileName)));
		stream.write(xmlAddAttribute("line", getLine()));
		// add the "line-end" attribute only if its different from the line attr
		if (getLine() != getEndLine())
			stream.write(xmlAddAttribute("line-end", getEndLine()));
		stream.write(xmlAddAttribute("offset", getOffset()));
		stream.write(xmlAddAttribute("offset-end", getEndOffset()));
		stream.write(">");
	}

	private void xmlSerializeElementClose(Writer stream, long depth) 
		throws IOException 
	{
		xmlFormat(stream, depth);
		stream.write("</" + encode(getText()) + ">");
	}

	public void xmlSerialize(Writer stream, String fileName, boolean indentXML) 
		throws IOException
	{
		bXMLIndent = indentXML;
		xmlSerialize(stream, 1, fileName);
	}

	private void xmlSerialize(Writer stream, long depth, String fileName) 
		throws IOException 
	{
		for (AST node = this; node != null; node = node.getNextSibling()) {
			LocationAST locationNode = (LocationAST)node;

			if (locationNode.getFirstChild() == null) {
				// print guts (class name, attributes)
				locationNode.xmlSerializeTextNode(stream, depth);
			} else {
				// print opening tag
				locationNode.xmlSerializeElementOpen(stream, depth, fileName);
				// print children
				locationNode.getFirstChild().
					xmlSerialize(stream, depth + 1, fileName);
				// print end tag
				locationNode.xmlSerializeElementClose(stream, depth);
			}
		}
	}

}
