#include "CheckNewMediaRemoved.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

#include "UEUserGuideClient.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
string CheckNewMediaRemoved::CheckNewMediaRemovedId = "UE_CHECK_NEW_MEDIA_STREAM_IS_REMOVED";

CheckNewMediaRemoved::CheckNewMediaRemoved()
{
  m_successor.reset();
}

CheckNewMediaRemoved::CheckNewMediaRemoved(boost::shared_ptr<EutIPInterface> eutIface)
{
  CheckNewMediaRemoved();
  m_eutIface = eutIface;
}

CheckNewMediaRemoved::~CheckNewMediaRemoved()
{
  Logger::Instance().LogInfo("CheckNewMediaRemoved::~CheckNewMediaRemoved");
  m_successor.reset();
}

int CheckNewMediaRemoved::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  
  // Process the command.
  if (trigger == CheckNewMediaRemoved::CheckNewMediaRemovedId)
  {
    int result = UEUserGuideClient::Instance().SendCommand(m_eutIface, trigger, parameterList);
    ss.str("");
    ss << "CheckNewMediaRemoved::Process: result=" << result;
    Logger::Instance().LogDebug(ss.str());
    if (result != 0)
    {
      // Processing failed.
      return 1; // Error - See TTCN-3 FncRetCode 
    }
    
    return 0/*result*/; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckNewMediaRemoved::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // Error - See TTCN-3 FncRetCode 
}

void CheckNewMediaRemoved::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

