#ifndef TriggerCommandsOffLine_CheckCallIsEnded_h
#define TriggerCommandsOffLine_CheckCallIsEnded_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
/*! Class CheckCallIsEnded
 * \brief This class provides processing for UE_CHECK_CALL_IS_ENDED Trigger command.
 */
class CheckCallIsEnded : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  static std::string CheckCallIsEndedId;
  
  boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> m_successor;
  
public:
  CheckCallIsEnded();
  ~CheckCallIsEnded();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor);
};

} } } // namespaces

#endif // TriggerCommandsOffLine_CheckCallIsEnded_h

