/*! file EquipmentAccessPort.h
 \brief This file provides support of TTCN-3 EquipmentAccessPort.
 */

#ifndef EquipmentAccessPort_h
#define EquipmentAccessPort_h

#include <t3devlib/t3devlib.h>

/*! Class EquipmentAccessPort
 * \brief This class implements the functionalities TTCN-3 EquipmentAccessPort management.
 */
class EquipmentAccessPort : public t3devlib::Port
{
public:
  //! Specialized ctor.
  /*! Specialized ctor.
   * @param id Port identifier.
   */
  EquipmentAccessPort (t3devlib::PortId& id);
  //! Default dtor.
  /*! Default dtor.
   */
  ~EquipmentAccessPort();

public:
  //! ProcessTriggerCommandsComplete.
  /*! Callback method called when UpperTester::InvokeProcessTriggerCommand() method is achieved.
   * @param to: reference to the component.
   */
	void ProcessTriggerCommandsComplete(const t3devlib::ComponentId &to);
	
protected:
  //! Map the port.
  bool Map (const t3devlib::PortId& port_id);
  //! Unmap the port.
  bool Unmap (const t3devlib::PortId& port_id);
  //! Send
  /*! Send a message to the port
   * @param from: identify the component
   * @param msg: encoded TTCN-3 message
   * @return true on success, false otherwise
   */
  bool Send (const t3devlib::ComponentId& from, const t3devlib::Bitstring& msg);

};

#endif // EquipmentAccessPort_h
