/**
 * @file TrafficCaptureMessageFactory.cpp
 * @author Tomas Urban
 * @version 0.2
 * @date 23/07/2009
 */
#include "TrafficCaptureMessageFactory.h"
#include "CommonTrafficCaptureMessages.h"
#include "CapturedData.h"
#include "Logger/Logger.h"

TrafficCaptureMessageFactory::TrafficCaptureMessageFactory(void)
{
}

TrafficCaptureMessageFactory::~TrafficCaptureMessageFactory(void)
{
}

TrafficCaptureMessage * TrafficCaptureMessageFactory::CreateMessage(unsigned short nId, const char * pPayload, 
	unsigned int nPayloadLength)
{
	TrafficCaptureMessage * pInstance = 0;
	std::string s;
	switch(nId)
	{
	case CAPTURED_PACKET_IND:
		s = "CapturedData";
		pInstance = new CapturedData();
		break;
	case SET_FILTER_REQ:
		s = "SetFilterRequest";
		pInstance = new SetFilterRequest();
		break;
	case START_CAPTURE_REQ:
		s = "StartCaptureRequest";
		pInstance = new StartCaptureRequest();
		break;
	case START_CAPTURE_REP:
		s = "StartCaptureReply";
		pInstance = new StartCaptureReply();
		break;
	case STOP_CAPTURE_REQ:
		s = "StopCaptureRequest";
		pInstance = new StopCaptureRequest();
		break;
	case STOP_CAPTURE_REP:
		s = "StopCaptureReply";
		pInstance = new StopCaptureReply();
		break;
	case OPEN_DEVICE_REQ:
		s = "OpenDeviceRequest";
		pInstance = new OpenDeviceRequest();
		break;
	case OPEN_DEVICE_REP:
		s = "OpenDeviceReply";
		pInstance = new OpenDeviceReply();
		break;
	case SET_FILTER_REP:
		s = "SetFilterReply";
		pInstance = new SetFilterReply();
		break;
	case MERGE_FILES_REQ:
		s = "MergePcapFilesRequest";
		pInstance = new MergePcapFilesRequest();
		break;
	case MERGE_FILES_REP:
		s = "MergePcapFilesReply";
		pInstance = new MergePcapFilesReply();
		break;
	}
	if (pInstance)
	{
		std::string sMsg = "Message instance created: ";
		sMsg += s;
		Logger::Instance().LogDebug(sMsg);
		Logger::Instance().LogDebug("Deserializing message...");
		if (!pInstance->DecodePayload(pPayload, nPayloadLength))
		{
			Logger::Instance().LogDebug("Message deserialization failed");
			delete pInstance;
			pInstance = 0;
		}
		else
			Logger::Instance().LogDebug("Deserializing completed successfully");
	}
	else
		Logger::Instance().LogDebug("Message instantiation failed: unknown message");
	return pInstance;
}

void TrafficCaptureMessageFactory::DisposeMessage(TrafficCaptureMessage * pInstance)
{
	delete pInstance;
}
