#ifndef DISSECTOR_FACTORY_H
#define DISSECTOR_FACTORY_H

#include "Helper/Singleton.h"
#include "Helper/Factory.h"
#include "Dissector.h"

/**
 * A singleton factory class for instantiating dissectors.
 */
class DissectorFactory  : public Factory<Dissector>, public Singleton<DissectorFactory> {

 protected:
  //Singleton
  friend class Singleton<DissectorFactory>;

  //Singleton
  DissectorFactory();

 public:
  virtual ~DissectorFactory();

};

#endif
