/**
 * @file PCAPLiveCapture.h
 * This header file defines the PCAPLiveCapture class.
 * @author Tomas Urban
 * @version 0.3
 * @date 22/07/2009
 */
#ifndef PCAP_LIVE_CAPTURE_H
#define PCAP_LIVE_CAPTURE_H

#include "PCAPCapture.h"
/**
 * Class used for real-time capture from network adapters using the pcap library.
 */
class PCAPLiveCapture :
	public PCAPCapture
{
public:
	PCAPLiveCapture();
	virtual ~PCAPLiveCapture(void);
	/**
	 * Initializes capturing object. The parameter contains a semicolon-separated list 
	 * of adapters in the pcap source syntax (i.e. rpcap:://Device). For more information
	 * about the format, please check pcap documentation.
	 * @param sParams List of adapters for capturing
	 * @return Operation success
	 */	
	virtual ECaptureInitResult OpenDevice(const std::string sParams);	
	/**
	 * Sets the path to a file into which the device should save captured traffic. 
	 * A successful #OpenDevice() call must precede, otherwise the method returns \c false.
	 * If capture is performed on several network adapters, several files will be created
	 * with adapter's ordinal number appended to the file name.
	 * @param sFile Name of the target file or empty string if the traffic should not 
	 * be saved.
	 * @return Operation success
	 */
	virtual bool SetCaptureFile(const std::string sFile);
};

#endif
