#ifndef  LIBIOTCODETS_H
#define  LIBIOTCODETS_H

#include <t3devlib/t3devlib.h>

namespace t3devlib {
namespace gen {

//
// Implementation of subtypes defined in the module LibIot_TypesAndValues
//

// aliases (subtypes without restrictions)
T3DEVLIB_BASIC_DEFINITION (LibUpperTester, EquipmentCommand, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibIot_TypesAndValues, IpAddress, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibIot_TypesAndValues, PortNumber, Unsigned);
//
  // Implementation of enumerated types (not handled by the generator yet)
  //
  
  class FncRetCode : public t3devlib::Enum {
  private:
    static const char* msFncRetCodeModes[];
  public:
    FncRetCode() : Enum (msFncRetCodeModes) {}
    
    const char* GetModuleName() const { return "LibCommon_VerdictControl"; }
    const char* GetTypeName() const   { return "FncRetCode"; }
    
    void Encode (Buffer& buffer) throw (EncodeError);
    void Decode (Buffer& buffer) throw (DecodeError);
  };
  
  
  class IOTExecMode : public t3devlib::Enum {
  private:
    static const char* msExecModes[];
  public:
    IOTExecMode() : Enum (msExecModes) {}
    
    const char* GetModuleName() const { return "LibIot_TypesAndValues"; }
    const char* GetTypeName() const   { return "IOTExecMode"; }
    
    void Encode (Buffer& buffer) throw (EncodeError);
    void Decode (Buffer& buffer) throw (DecodeError);
  };
  
  
  class IOTVerdictType : public t3devlib::Enum {
  private:
    static const char* msVerdictTypes[];
  public:
    IOTVerdictType() : Enum (msVerdictTypes) {}
    
    const char* GetModuleName() const { return "LibIot_TypesAndValues"; }
    const char* GetTypeName() const   { return "IOTVerdictType"; }
    
    void Encode (Buffer& buffer) throw (EncodeError);
    void Decode (Buffer& buffer) throw (DecodeError);
  };

  class RecordMode : public t3devlib::Enum {
  private:
    static const char* msRecordModes[];
  public:
    RecordMode() : Enum (msRecordModes) {}
    
    const char* GetModuleName() const { return "LibIot_TypesAndValues"; }
    const char* GetTypeName() const   { return "RecordMode"; }
    
    void Encode (Buffer& buffer) throw (EncodeError);
    void Decode (Buffer& buffer) throw (DecodeError);
  };

  class ProtocolFilter : public t3devlib::Enum {
  private:
    static const char* msProtocolFilterModes[];
  public:
    ProtocolFilter() : Enum (msProtocolFilterModes) {}
    
    const char* GetModuleName() const { return "LibIot_TypesAndValues"; }
    const char* GetTypeName() const   { return "ProtocolFilter"; }
    
    void Encode (Buffer& buffer) throw (EncodeError);
    void Decode (Buffer& buffer) throw (DecodeError);
  };

    
}} //namespaces

#endif
