#ifndef TriggerCommandsOffLine_CheckNewMediaAdded_h
#define TriggerCommandsOffLine_CheckNewMediaAdded_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
/*! Class CheckNewMediaAdded
 * \brief This class provides processing for UE_CHECK_NEW_MEDIA_STREAM_IS_ADDED Trigger command.
 */
class CheckNewMediaAdded : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  static std::string CheckNewMediaAddedId;
  
  boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> m_successor;
  
  boost::shared_ptr<EutIPInterface> m_eutIface;
  
public:
  CheckNewMediaAdded();
  CheckNewMediaAdded(boost::shared_ptr<EutIPInterface> eutIface);
  ~CheckNewMediaAdded();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor);
};

} } } // namespaces

#endif // TriggerCommandsOffLine_CheckNewMediaAdded_h

