#include "CheckIsNotRegistered.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
string CheckIsNotRegistered::CheckIsNotRegisteredId = "UE_CHECK_IS_NOT_REGISTERED";

CheckIsNotRegistered::CheckIsNotRegistered()
{
  m_successor.reset();
}

CheckIsNotRegistered::CheckIsNotRegistered(boost::shared_ptr<EutIPInterface> eutIface)
{
  CheckIsNotRegistered();
  m_eutIface = eutIface;
}

CheckIsNotRegistered::~CheckIsNotRegistered()
{
  Logger::Instance().LogInfo("CheckIsNotRegistered::~CheckIsNotRegistered");
  m_successor.reset();
}

int CheckIsNotRegistered::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  // Process the command.
  if (trigger == CheckIsNotRegistered::CheckIsNotRegisteredId)
  {
    ss << "CheckIsNotRegistered::Process: " << trigger;
    Logger::Instance().LogDebug(ss.str());
    
    return 0; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckIsNotRegistered::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // See TTCN-3 FncRetCode 
}

void CheckIsNotRegistered::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

