#include "CheckCallIsEnded.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

#include "UEUserGuideClient.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
string CheckCallIsEnded::CheckCallIsEndedId = "UE_CHECK_CALL_IS_ENDED";

CheckCallIsEnded::CheckCallIsEnded()
{
	m_successor.reset();
}

CheckCallIsEnded::CheckCallIsEnded(boost::shared_ptr<EutIPInterface> eutIface)
{
  CheckCallIsEnded();
  m_eutIface = eutIface;
}

CheckCallIsEnded::~CheckCallIsEnded()
{
  Logger::Instance().LogInfo("CheckCallIsEnded::~CheckCallIsEnded");
  m_successor.reset();
}

int CheckCallIsEnded::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  
  // Process the command.
  if (trigger == CheckCallIsEnded::CheckCallIsEndedId)
  {
    int result = UEUserGuideClient::Instance().SendCommand(m_eutIface, trigger, parameterList);
    ss.str("");
    ss << "CheckCallIsEnded::Process: result=" << result;
    Logger::Instance().LogDebug(ss.str());
    if (result != 0)
    {
      // Processing failed.
      return 1; // Error - See TTCN-3 FncRetCode 
    }
    
    return 0/*result*/; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckCallIsEnded::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // Error - See TTCN-3 FncRetCode 
}

void CheckCallIsEnded::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

