#ifndef TriggerCommandsGUI_CheckCallIsAnswered_h
#define TriggerCommandsGUI_CheckCallIsAnswered_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
/*! Class CheckCallIsAnswered
 * \brief This class provides processing for UE_CHECK_CALL_IS_ANSWERED Trigger command.
 */
class CheckCallIsAnswered : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  static std::string CheckCallIsAnsweredId;
  
  boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> m_successor;
  
  boost::shared_ptr<EutIPInterface> m_eutIface;
  
public:
  CheckCallIsAnswered();
  CheckCallIsAnswered(boost::shared_ptr<EutIPInterface> eutIface);
  ~CheckCallIsAnswered();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor);
};

} } } // namespaces

#endif // TriggerCommandsGUI_CheckCallIsAnswered_h

