#include "CheckCallIsAnswered.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

#include "UEUserGuideClient.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
string CheckCallIsAnswered::CheckCallIsAnsweredId = "UE_CHECK_CALL_IS_ANSWERED";

CheckCallIsAnswered::CheckCallIsAnswered()
{
  m_successor.reset();
}

CheckCallIsAnswered::CheckCallIsAnswered(boost::shared_ptr<EutIPInterface> eutIface)
{
  CheckCallIsAnswered();
  m_eutIface = eutIface;
}

CheckCallIsAnswered::~CheckCallIsAnswered()
{
  Logger::Instance().LogInfo("CheckCallIsAnswered::~CheckCallIsAnswered");
  m_successor.reset();
}

int CheckCallIsAnswered::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  
  // Process the command.
  if (trigger == CheckCallIsAnswered::CheckCallIsAnsweredId)
  {
    int result = UEUserGuideClient::Instance().SendCommand(m_eutIface, trigger, parameterList);
    ss.str("");
    ss << "CheckCallIsAnswered::Process: result=" << result;
    Logger::Instance().LogDebug(ss.str());
    if (result != 0)
    {
      // Processing failed.
      return 1; // Error - See TTCN-3 FncRetCode 
    }
    
    return 0/*result*/; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckCallIsAnswered::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // Error - See TTCN-3 FncRetCode 
}

void CheckCallIsAnswered::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

