#ifndef AdapterConfigPort_h
#define AdapterConfigPort_h

#include <t3devlib/t3devlib.h>

#define MTC "ImsTestCoordinator"

class AdapterConfigPort : public t3devlib::Port
{
 public:
  AdapterConfigPort (t3devlib::PortId& PortId);
  ~AdapterConfigPort();
  const t3devlib::ComponentId* Filter();
  const t3devlib::PortId& GetConnectedPort(const t3devlib::ComponentId *pComponentId);
  bool ProcessResponse (const std::string& message, unsigned char result, const t3devlib::PortId *to=0);
  
 protected:
  bool Map (const t3devlib::PortId& connectedPortId);
  bool Unmap (const t3devlib::PortId& connectedPortId);
  bool Send (const t3devlib::ComponentId& from, const t3devlib::Bitstring& bsMsg);
  
 private:
  unsigned char ProcessGeneralConfigurationReq(const std::string & frame, int offset);
  unsigned char ProcessStartCaptureReq(const std::string & frame, int offset);
  unsigned char ProcessStopCaptureReq(const std::string & frame, int offset);
  unsigned char ProcessSetFilterReq(const std::string & frame, int offset, const t3devlib::ComponentId& from);
  
 private:
  std::list<const t3devlib::PortId *> m_connectedPorts;
  const t3devlib::PortId *m_mtcPortId;
};

#endif // AdapterConfigPort_h
