#ifndef UDP_DISSECTOR_H
#define UDP_DISSECTOR_H

#include "Dissector.h"
#include <string>

class UdpDissector : public Dissector {

 public:
  UdpDissector();
  virtual ~UdpDissector();
  virtual UdpDissector * Clone() const;
  virtual bool Dissect(const unsigned char * pData, const ssize_t nDataLen);
  virtual bool NeedReassembly() const;
  virtual const EProtocolType GetUpperLayerType() const;

 private:
  struct UdpHeader {
    unsigned short srcPort;         // Source port no.
    unsigned short destPort;        // Dest. port no.
    unsigned short length;          // UDP packet length
    unsigned short checksum;        // UDP checksum (optional)
  };

 private:
  UdpHeader * m_udpHdr;
 protected:
  ProtocolInfoElement * CreateLayerInfo();
};

#endif
