#ifndef ETHERNET_DISSECTOR_H
#define ETHERNET_DISSECTOR_H

#include "Dissector.h"
#include <map>
#include <string>

class EthernetDissector : public Dissector {

 public:
  EthernetDissector();
  virtual ~EthernetDissector();
  virtual EthernetDissector * Clone() const;
  virtual bool Dissect(const unsigned char * pData, const ssize_t nDataLen);
  virtual bool NeedReassembly() const;
  virtual const EProtocolType GetUpperLayerType() const;

 private:
  struct EthernetHeader {
    unsigned char destination[6];
    unsigned char source[6];
    unsigned short type;
  };
  EthernetHeader * m_ethHdr;
protected:
  ProtocolInfoElement * CreateLayerInfo();
};

#endif
