#include "EthernetDissector.h"
#include "Logger/Logger.h"

EthernetDissector::EthernetDissector() 
{
}

EthernetDissector::~EthernetDissector() {
  delete m_ethHdr;
}

EthernetDissector * EthernetDissector::Clone() const {
  return new EthernetDissector();
}

bool EthernetDissector::Dissect(const unsigned char * pData, const ssize_t nLen) {
 
  m_ethHdr = new EthernetHeader;
  memcpy(m_ethHdr, pData, sizeof(EthernetHeader));
  pData += sizeof(EthernetHeader);

  SavePayload(pData, nLen - sizeof(EthernetHeader));
  return true;
}

bool EthernetDissector::NeedReassembly() const {
  return false;
}

const EProtocolType EthernetDissector::GetUpperLayerType() const 
{
	EProtocolType res = EProtocolType_Unknown;
	switch(m_ethHdr->type)
	{
		case 8:
			res = EProtocolType_IPv4;
			break;
	}
	return res;
}


ProtocolInfoElement * EthernetDissector::CreateLayerInfo()
{
	return 0;
}