#include "DispatcherFactory.h"
#include "EthernetDispatcher.h"
#include "IpDispatcher.h"
#include "UdpDispatcher.h"
#include "TcpDispatcher.h"
#include "SipDispatcher.h"

DispatcherFactory::DispatcherFactory() {
  Register(EProtocolType_Ethernet, &(EthernetDispatcher::Instance()));
  Register(EProtocolType_IPv4, &(IpDispatcher::Instance()));
  Register(EProtocolType_Udp, &(UdpDispatcher::Instance()));
  Register(EProtocolType_Tcp, &(TcpDispatcher::Instance()));
  Register(EProtocolType_Sip, &(SipDispatcher::Instance()));
}

DispatcherFactory::~DispatcherFactory() {

}

