/**
 * @file TcpipDispatch.h
 * This header file defines the TcpipDispatch class.
 * @author Tomas Urban
 * @version 0.2
 * @date 21/07/2009
 */
#ifndef TCPIP_DISPATCH_H
#define TCPIP_DISPATCH_H

#include "CaptureDispatch.h"
#include <boost/thread/mutex.hpp>
#include "TcpipDefs.h"

/**
 * This class uses a TCP/IP connection for dispatching captured data messages.
 */
class TcpipDispatch :
	public CaptureDispatch
{
private:
	boost::mutex m_mutex;
	SOCKET_TYPE m_hSocket;
public:
	/**
	 * The constructor requires a handle to an existing socket. This socket is then used
	 * for sending captured messages to a remote host.
	 * @param hSocket Socket handle
	 */
	TcpipDispatch(SOCKET_TYPE hSocket);
	virtual ~TcpipDispatch(void);
	/**
	 * This method stops sending messages over the underlying TCP/IP connection. The method
	 * is typically used in closing scenarios.
	 */
	void Stop();
	virtual void DispatchData(CapturedData * pData);
};

#endif
