/**
 * @file TcpipDispatch.cpp
 * @author Tomas Urban
 * @version 0.2
 * @date 23/07/2009
 */
#include "TcpipDispatch.h"
#include "Logger/Logger.h"

TcpipDispatch::TcpipDispatch(SOCKET_TYPE hSocket)
{
	m_hSocket = hSocket;
}

TcpipDispatch::~TcpipDispatch(void)
{
	Stop();
}

void TcpipDispatch::Stop()
{
	m_hSocket = 0;
}

void TcpipDispatch::DispatchData(CapturedData * pData)
{
	if (m_hSocket)
	{		
		{
			boost::mutex::scoped_lock lock(m_mutex);
			// send data
			send(m_hSocket, pData->GetEncodedMessage(), pData->GetEncodedDataLength(), 0);
		}
		Logger::Instance().LogCapture(pData->ToString());
	}
}
