/**
 * @file CaptureFactory.h
 * This header file defines the CaptureFactory class.
 * @author Tomas Urban
 * @version 0.1
 * @date 16/07/2009
 */
#ifndef CAPTURE_FACTORY_H
#define CAPTURE_FACTORY_H

#include "GenericCapture.h"
#include "Helper/Singleton.h"

/**
 * A singleton factory class for instantiating received data messages.
 */
class CaptureFactory  : public Singleton<CaptureFactory>
{
private:
	friend class Singleton<CaptureFactory>;
	CaptureFactory(void);
public:
	~CaptureFactory(void);
	/**
	 * The factory method for creating capture device instances based on supplied
	 * device type and mode. The objects returned by this method are allocated on the heap, so they
	 * have to be disposed when they are not needed anymore by the \c delete operator or
	 * calling the #DisposeCaptureInstance method.
	 * @param captureType Type of the capturing device
	 * @param captureMode Capturing mode (live or offline)
	 * @return Created device instance or \c NULL if any error has ocurred (e.g. unknown
	 * or unsupported device).
	 */
	GenericCapture * CreateCaptureInstance(ECaptureType captureType,
		ECaptureMode captureMode);
	/**
	 * This method is used for disposing instances allocated by the #CreateCaptureInstance method.
	 * @param pInstance Capture device instance to be disposed
	 */
	void DisposeCaptureInstance(GenericCapture * pInstance);
};

#endif
