/**
 * @file CaptureDispatch.h
 * This header file defines the CaptureDispatch class.
 * @author Tomas Urban
 * @version 0.1
 * @date 16/07/2009
 */
#ifndef CAPTURE_DISPATCH_H
#define CAPTURE_DISPATCH_H

#include "Messages/CapturedData.h"

/**
 * An abstract class providing a generic interface for dispatching captured data. The
 * exact way how the dispatching mechanism works is defined in child classes 
 * (strategy design pattern).
 */
class CaptureDispatch
{
protected:
	CaptureDispatch(void) {};
public:
	virtual ~CaptureDispatch(void) {};
	/**
	 * Dispatches captured data to the recipient.
	 * @param pData Captured data to be dispatched
	 */
	virtual void DispatchData(CapturedData * pData) = 0;
};

#endif
