/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TransformerReceiver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.MessageListenerProxy;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;

public class XsltTransformer
implements Destination {
    private Processor processor;
    private Controller controller;
    private NodeInfo initialContextNode;
    private Destination destination;

    protected XsltTransformer(Processor processor, Controller controller) {
        this.processor = processor;
        this.controller = controller;
    }

    public void setInitialTemplate(QName templateName) throws SaxonApiException {
        try {
            this.controller.setInitialTemplate(templateName == null ? null : templateName.getClarkName());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public QName getInitialTemplate() {
        String template = this.controller.getInitialTemplate();
        return template == null ? null : QName.fromClarkName(template);
    }

    public void setInitialMode(QName modeName) {
        this.controller.setInitialMode(modeName == null ? null : modeName.getClarkName());
    }

    public QName getInitialMode() {
        String mode = this.controller.getInitialMode();
        if (mode == null) {
            return null;
        }
        return QName.fromClarkName(mode);
    }

    public void setSource(Source source) throws SaxonApiException {
        this.setInitialContextNode(this.processor.newDocumentBuilder().build(source));
    }

    public void setInitialContextNode(XdmNode node) {
        this.initialContextNode = node == null ? null : node.getUnderlyingNode();
    }

    public XdmNode getInitialContextNode() {
        return (XdmNode)XdmValue.wrap((ValueRepresentation)this.initialContextNode);
    }

    public void setParameter(QName name, XdmValue value) {
        this.controller.setParameter(name.getStructuredQName(), value == null ? null : value.getUnderlyingValue());
    }

    public XdmValue getParameter(QName name) {
        Object oval = this.controller.getParameter(name.getClarkName());
        if (oval == null) {
            return null;
        }
        if (oval instanceof ValueRepresentation) {
            return XdmValue.wrap((ValueRepresentation)oval);
        }
        throw new IllegalStateException(oval.getClass().getName());
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setMessageListener(MessageListener listener) {
        this.controller.setMessageEmitter((Receiver)new MessageListenerProxy(listener));
    }

    public MessageListener getMessageListener() {
        Receiver r = this.controller.getMessageEmitter();
        if (r instanceof MessageListenerProxy) {
            return ((MessageListenerProxy)r).getMessageListener();
        }
        return null;
    }

    public void transform() throws SaxonApiException {
        if (this.destination == null) {
            throw new IllegalStateException("No destination has been supplied");
        }
        try {
            Receiver receiver = this.destination instanceof Serializer ? ((Serializer)this.destination).getReceiver(this.controller.getConfiguration(), this.controller, this.controller.getOutputProperties()) : this.destination.getReceiver(this.controller.getConfiguration());
            this.controller.transform((Source)this.initialContextNode, (Result)receiver);
        }
        catch (TransformerException e) {
            throw new SaxonApiException(e);
        }
    }

    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        if (this.destination == null) {
            throw new IllegalStateException("No destination has been supplied");
        }
        TransformerReceiver tr = new TransformerReceiver(this.controller);
        tr.setResult((Result)this.destination.getReceiver(config));
        tr.setPipelineConfiguration(this.controller.makePipelineConfiguration());
        return tr;
    }

    public Controller getUnderlyingController() {
        return this.controller;
    }
}

