package elements;

import java.util.LinkedList;

import org.etsi.common.logging.LoggingInterface.MessageClass;
import org.etsi.t3d.T3D;


public class TTCN3Element{

	private String type;
	private int LEVEL0 = 0;
	protected String behaviour;
	protected TTCN3Comment comment = null;
	protected String name = "";
	protected String location = "";
	protected String paramView = "";
	protected String refs = "";
	protected String path = "";
	private LinkedList <String[]> descs = new LinkedList<String[]>();
	
	public TTCN3Element() {
		
	}
	
	//TODO: using type codes will be presumably preferable
	//TODO: HELP!!! THIS IS A DISASTER!!!!! REORGANIZE AND REFACTOR
	public TTCN3Element(String name, String type, String location,
			String behaviour, TTCN3Comment comment, 
			LinkedList <String> parNames, String filename, String paramView, String path, int line){
		this.name = name;
		this.location = location;
		this.behaviour = behaviour;
		this.comment = comment;
		this.type = type;
		this.paramView = paramView;
		this.path = path;
		
		
		
		for(String warning : comment.getWarnings()) {
			
//			TODO: revise XML usage
//			T3D.printLog(LEVEL0, filename, line, line, 1, warning);
			T3D.getLoggingInterface().logWarning(line, line, MessageClass.DOCUMENTATION, warning);
		}
		
		LinkedList <String> descsStrings = comment.getDescriptions();
		for(String descString : descsStrings){
			String[] descArray = {descString, filename, "" + line}; 
			descs.add(descArray);
		}
		
		
		
		LinkedList <String> docParNames = comment.getDocumentedParameters();
		
		
		LinkedList <String> unDocParNames = new LinkedList<String>();
		LinkedList <String> docUnparNames = new LinkedList<String>();
		if(!parNames.isEmpty() && T3D.activeProfile.isCheckUndocumentedParameters()){
			for(String parString : parNames){
				boolean isDocumented = false;
				for(String docParString : docParNames){
					if(parString.startsWith(docParString + " "))
						isDocumented = true;
				}
				if(!isDocumented)
					unDocParNames.add(parString);
			}
			
			
			for(String docParString : docParNames){
				boolean isParameter = false;
				for(String parString : parNames){
					if(parString.startsWith(docParString + " "))
						isParameter = true;
				}
				if(!isParameter)
					docUnparNames.add(docParString);
			}
			
			for(String s : unDocParNames){
				String parName = s.substring(0, s.indexOf(' '));
				Integer parLine = Integer.valueOf(s.substring(s.indexOf(' ')+1)).intValue();
				String warning = "Undocumented parameter found: " + parName ;
//				TODO: review XML usage
//				T3D.printLog(LEVEL0, filename, parLine, parLine, 1, warning);
				T3D.getLoggingInterface().logWarning(parLine, parLine, MessageClass.DOCUMENTATION, warning);
			}
			
			for(String s : docUnparNames){
				String warning = "Documented parameter not found: " + s ;
				//TODO: review XML usage
//				T3D.printLog(LEVEL0, filename, line, line, 1, warning);
				T3D.getLoggingInterface().logWarning(line, line, MessageClass.DOCUMENTATION, warning);

			}
		}
	}
	
	public String toXML(String currentModule){
		return "<element type=\"" + type + "\">\n" +
				"<name>" + name + "</name>\n" +
				"<location>" + location + "</location>\n" +
				comment.toString() +
				"<behaviour>" + behaviour.replaceAll("<tab/>", "     ") + "</behaviour>" +
				"<modulename>" + currentModule + "</modulename>" +
				paramView +
				refs +
				path +
				"</element>";
	}
	
	public String getType(){
		return type;
	}
	public LinkedList<String[]> getDescs() {
		return descs;
	}
	public String getName(){
		return name;
	}
	public String getLocation(){
		return location;
	}
}
