/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public final class AtomicMappingExpression
extends SlashExpression
implements ContextMappingFunction {
    public AtomicMappingExpression(Expression start, Expression step) {
        super(start, step);
    }

    public boolean isHybrid() {
        return false;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    public Expression copy() {
        return new AtomicMappingExpression(this.getStartExpression().copy(), this.getStepExpression().copy());
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator result = this.start.iterate(context);
        XPathContextMinor context2 = context.newMinorContext();
        context2.setCurrentIterator(result);
        context2.setOrigin(this);
        context2.setOriginatingConstructType(2025);
        return new ContextMappingIterator(this, context2);
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("atomicMap");
        this.getStartExpression().explain(destination);
        this.getStepExpression().explain(destination);
        destination.endElement();
    }
}

