/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.xpath.XPathEvaluator;

public class XPathFactoryImpl
extends XPathFactory {
    private Configuration config;
    private XPathVariableResolver variableResolver;
    private XPathFunctionResolver functionResolver;
    private static String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";

    public XPathFactoryImpl() {
        this.config = this.makeConfiguration();
    }

    public XPathFactoryImpl(Configuration config) {
        this.config = config;
    }

    protected Configuration makeConfiguration() {
        return new Configuration();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean isObjectModelSupported(String model) {
        return this.config.getExternalObjectModel(model) != null;
    }

    public void setFeature(String feature, boolean b) throws XPathFactoryConfigurationException {
        if (feature.equals(FEATURE_SECURE_PROCESSING)) {
            this.config.setAllowExternalFunctions(!b);
        } else if (feature.equals("http://saxon.sf.net/feature/schema-validation")) {
            this.config.setSchemaValidationMode(b ? 1 : 4);
        } else {
            throw new XPathFactoryConfigurationException("Unknown feature: " + feature);
        }
    }

    public boolean getFeature(String feature) throws XPathFactoryConfigurationException {
        if (feature.equals(FEATURE_SECURE_PROCESSING)) {
            return !this.config.isAllowExternalFunctions();
        }
        if (feature.equals("http://saxon.sf.net/feature/schema-validation")) {
            return this.config.getSchemaValidationMode() == 1;
        }
        throw new XPathFactoryConfigurationException("Unknown feature: " + feature);
    }

    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.variableResolver = xPathVariableResolver;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        this.functionResolver = xPathFunctionResolver;
    }

    public XPath newXPath() {
        XPathEvaluator xpath = new XPathEvaluator(this.config);
        xpath.setXPathFunctionResolver(this.functionResolver);
        xpath.setXPathVariableResolver(this.variableResolver);
        return xpath;
    }
}

