/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortKeyEvaluator;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Value;
import org.xml.sax.InputSource;

public class XPathExpressionImpl
implements XPathExpression,
SortKeyEvaluator {
    private Configuration config;
    private Executable executable;
    private Expression expression;
    private Expression atomizer;
    private NodeInfo contextNode;
    private SlotManager stackFrameMap;
    private XPathExpressionImpl sortKey = null;

    protected XPathExpressionImpl(Expression exp, Executable exec) {
        this.expression = exp;
        this.executable = exec;
        this.config = exec.getConfiguration();
    }

    protected void setStackFrameMap(SlotManager map) {
        this.stackFrameMap = map;
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setSortKey(XPathExpressionImpl sortKey) {
        this.sortKey = sortKey;
    }

    public void setContextNode(NodeInfo node) {
        if (node == null) {
            throw new NullPointerException("Context node cannot be null");
        }
        if (node.getConfiguration() != this.config) {
            throw new IllegalArgumentException("Supplied node uses the wrong Configuration");
        }
        this.contextNode = node;
    }

    protected void privatelySetContextNode(NodeInfo node) {
        if (node == null) {
            throw new NullPointerException("Context node cannot be null");
        }
        if (node.getConfiguration() != this.config) {
            throw new IllegalArgumentException("Supplied node uses the wrong Configuration");
        }
        this.contextNode = node;
    }

    public List evaluate() throws XPathException {
        XPathContextMajor context = new XPathContextMajor((Item)this.contextNode, this.executable);
        context.openStackFrame(this.stackFrameMap);
        SequenceIterator iter = this.expression.iterate((XPathContext)context);
        SequenceExtent extent = new SequenceExtent(iter);
        return (List)PJConverter.ToCollection.INSTANCE.convert((ValueRepresentation)extent, List.class, (XPathContext)context);
    }

    public Object evaluateSingle() throws XPathException {
        XPathContextMajor context = new XPathContextMajor((Item)this.contextNode, this.executable);
        context.openStackFrame(this.stackFrameMap);
        SequenceIterator iterator = this.expression.iterate((XPathContext)context);
        Item item = iterator.next();
        if (item == null) {
            return null;
        }
        return Value.convertToJava((Item)item);
    }

    public SequenceIterator rawIterator(Item contextItem) throws XPathException {
        XPathContextMajor context = new XPathContextMajor(contextItem, this.executable);
        return this.rawIterator(context);
    }

    private SequenceIterator rawIterator(XPathContextMajor context) throws XPathException {
        context.openStackFrame(this.stackFrameMap);
        SequenceIterator iterator = this.expression.iterate((XPathContext)context);
        if (this.sortKey != null) {
            Expression key = this.sortKey.expression;
            if (key.getItemType(this.config.getTypeHierarchy()) instanceof NodeTest) {
                this.sortKey.expression = new Atomizer(key, this.config);
            }
            SortKeyDefinition sk = new SortKeyDefinition();
            sk.setSortKey(this.sortKey.expression);
            AtomicComparer comp = sk.makeComparator((XPathContext)context);
            AtomicComparer[] comps = new AtomicComparer[]{comp};
            iterator = new SortedIterator((XPathContext)context, iterator, (SortKeyEvaluator)this, comps);
            ((SortedIterator)iterator).setHostLanguage(54);
        }
        return iterator;
    }

    public Object evaluate(Object node, QName qName) throws XPathExpressionException {
        NodeInfo contextNode = this.contextNode;
        if (node != null) {
            if (node instanceof SingletonNode) {
                node = ((SingletonNode)node).getNode();
            }
            if (node instanceof NodeInfo) {
                if (!((NodeInfo)node).getConfiguration().isCompatible(this.config)) {
                    throw new XPathExpressionException("Supplied node must be built using the same or a compatible Configuration");
                }
                contextNode = (NodeInfo)node;
            } else {
                ValueRepresentation val;
                JPConverter converter = JPConverter.allocate(node.getClass(), (Configuration)this.config);
                try {
                    val = converter.convert(node, (XPathContext)new EarlyEvaluationContext(this.config, null));
                }
                catch (XPathException e) {
                    throw new XPathExpressionException("Failure converting a node of class " + node.getClass().getName() + ": " + e.getMessage());
                }
                if (val instanceof NodeInfo) {
                    contextNode = (NodeInfo)val;
                } else {
                    throw new XPathExpressionException("Cannot locate an object model implementation for nodes of class " + node.getClass().getName());
                }
            }
        }
        XPathContextMajor context = new XPathContextMajor((Item)contextNode, this.executable);
        context.openStackFrame(this.stackFrameMap);
        try {
            SequenceIterator iter;
            if (qName.equals(XPathConstants.BOOLEAN)) {
                return this.expression.effectiveBooleanValue((XPathContext)context);
            }
            if (qName.equals(XPathConstants.STRING)) {
                iter = this.expression.iterate((XPathContext)context);
                Item first = iter.next();
                if (first == null) {
                    return "";
                }
                return first.getStringValue();
            }
            if (qName.equals(XPathConstants.NUMBER)) {
                Item first;
                if (this.atomizer == null) {
                    this.atomizer = new Atomizer(this.expression, this.config);
                }
                if ((first = (iter = this.atomizer.iterate((XPathContext)context)).next()) == null) {
                    return new Double(Double.NaN);
                }
                if (first instanceof NumericValue) {
                    return new Double(((NumericValue)first).getDoubleValue());
                }
                DoubleValue v = NumberFn.convert((AtomicValue)((AtomicValue)first));
                return new Double(v.getDoubleValue());
            }
            if (qName.equals(XPathConstants.NODE)) {
                iter = this.expression.iterate((XPathContext)context);
                Item first = iter.next();
                if (first instanceof VirtualNode) {
                    return ((VirtualNode)first).getUnderlyingNode();
                }
                if (first == null || first instanceof NodeInfo) {
                    return first;
                }
                throw new XPathExpressionException("Expression result is not a node");
            }
            if (qName.equals(XPathConstants.NODESET)) {
                iter = this.rawIterator(context);
                SequenceExtent extent = new SequenceExtent(iter);
                PJConverter converter = PJConverter.allocateNodeListCreator((Configuration)this.config, (Object)node);
                return converter.convert((ValueRepresentation)extent, Object.class, (XPathContext)context);
            }
            throw new IllegalArgumentException("qName: Unknown type for expected result");
        }
        catch (XPathException e) {
            throw new XPathExpressionException(e);
        }
    }

    public String evaluate(Object node) throws XPathExpressionException {
        return (String)this.evaluate(node, XPathConstants.STRING);
    }

    public Object evaluate(InputSource inputSource, QName qName) throws XPathExpressionException {
        if (qName == null) {
            throw new NullPointerException("qName");
        }
        try {
            DocumentInfo doc = null;
            if (inputSource != null) {
                doc = this.config.buildDocument((Source)new SAXSource(inputSource));
            }
            return this.evaluate(doc, qName);
        }
        catch (XPathException e) {
            throw new XPathExpressionException(e);
        }
    }

    public String evaluate(InputSource inputSource) throws XPathExpressionException {
        if (inputSource == null) {
            throw new NullPointerException("inputSource");
        }
        try {
            DocumentInfo doc = this.config.buildDocument((Source)new SAXSource(inputSource));
            return (String)this.evaluate(doc, XPathConstants.STRING);
        }
        catch (XPathException e) {
            throw new XPathExpressionException(e);
        }
    }

    public Item evaluateSortKey(int n, XPathContext c) throws XPathException {
        return this.sortKey.getInternalExpression().evaluateItem(c);
    }

    public Expression getInternalExpression() {
        return this.expression;
    }
}

