#ifndef UpperTestAdapter_h
#define UpperTestAdapter_h

// Boost headers.
#include <boost/shared_ptr.hpp>
// Singleton pattern.
#include "Helper/Singleton.h"
#include "Helper/GeneralConfigurationParams.h"
#include "Helper/Exceptions.h"

#include "Messages/CommonTrafficCaptureMessages.h"
// TTCN-3 ports.
#include "Ports/EquipmentAccessPort.h"
// Internal UpperTestAdapter.
#include "Processors/ProcessorsImpl.h"

namespace UpperTestAdapter {

/*! Class UpperTestAdapter
 * \brief This class implements the processing of TriggerCommands messages and Eut configuration commands.
 * This class is used as a singleton.
 */
class UpperTestAdapter  : public Singleton<UpperTestAdapter>
{
  //! Singleton pattern implementation.
  friend class Singleton<UpperTestAdapter>;
  
  //! UpperTestAdapter.
  /*! Default ctor. Shall be declared in private part due to Singleton pattern implementation.
   */
  UpperTestAdapter();

  /*
   * Port registering part.
   */
  //! Mapping of the registered EquipmentAccessPort ports.
  std::map<const t3devlib::ComponentId *, std::pair<t3devlib::PortId *, boost::shared_ptr<Processors::ProcessorsImpl> > >  m_mapRegisteredPorts;
  /*! This list will be used to assign properly the EUT interfaces description sent into GeneralConfigurationReq with the ports.
   * Becarefull: the order of the EIUT registration port SHALL be the same than the EUT interfaces description
   */
  std::list<const t3devlib::ComponentId *> m_connectedComponents;
  
public:
  //! Default dtor.
  /*! Default dtor.
   */
  ~UpperTestAdapter();
  
public: // Public interface
  //! Initialize the component.
  /*! Initialize the component.
   * @param configParams: GeneralConfigureReq parmeters.
   * @return true on success, false otherwise.
   */
  bool Initialize(boost::shared_ptr<GeneralConfigurationParams> configParams) throw(UpperTestAdapterException);
  //! Register a new TriggerPort TTCN-3 port instance.
  /*! Register a new TriggerPort TTCN-3 port instance.
   * @param pPort: port instance
   * @param pComponent: TTCN-3 component reference
   */
  void RegisterEquipmentAccessPort(t3devlib::PortId *pPort, const t3devlib::ComponentId *pComponent);
  //void RegisterEutConfigPort(PortId *pPort, const ComponentId *pComponent);  
  //! Register a new EutConfigPort TTCN-3 port instance.
  /*! Register a new EutConfigPort instance.
   * @param pComponent: TTCN-3 component reference
   * @return PortId reference on success, NULL otherwise.
   */
  t3devlib::PortId * GetEquipmentAccessPortIdFromComponent(const t3devlib::ComponentId& from);
  
  // TODO: Add Deregister port to free smart pointers.
  
  
  //! ProcessTriggerCommand.
  /*! Process a TriggerCommands message in synchronous mode.
   * @param from:
   * @param signatureId: Component referencetrigger
   * @param trigger: trigger command
   * @param parameterList:
   * @return true on success, false otherwise.
   */
  int ProcessTriggerCommand(const t3devlib::ComponentId &from, const std::string &trigger, const std::vector<std::string> &parameterList);

  // TODO: Add asynchronous Trigger command processing
  //void InvokeProcessTriggerCommand(const t3devlib:ComponentId &from, const t3devlib:QName &signatureId, const ParameterList &parameterList);
};

} // namespace

#endif // UpperTestAdapter_h
