#ifndef STF370_PacketFilter_h
#define STF370_PacketFilter_h

#include <string>
#include "PacketFilterExpression.h"
#include "PacketDissector.h"

using namespace std;

enum FilterOperator {
  FO_NONE,
  FO_AND,
  FO_OR
};
	
class PacketFilter {

 public:
  PacketFilter(const string& sFilter = "");
  virtual ~PacketFilter();
  const string& GetFilter() const;
  bool Match(const PacketDissector& packet) const;

 private:
  PacketFilter *m_right;
  PacketFilter *m_left;
  FilterOperator m_operator;
  PacketFilterExpression *m_expr;
  bool m_valid;

};

#endif
