#include "CheckIsRegistered.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
string CheckIsRegistered::CheckIsRegisteredId = "UE_CHECK_IS_REGISTER";

CheckIsRegistered::CheckIsRegistered()
{
  m_successor.reset();
}

CheckIsRegistered::CheckIsRegistered(boost::shared_ptr<EutIPInterface> eutIface)
{
  CheckIsRegistered();
  m_eutIface = eutIface;
}

CheckIsRegistered::~CheckIsRegistered()
{
  Logger::Instance().LogInfo("CheckIsRegistered::~CheckIsRegistered");
  m_successor.reset();
}

int CheckIsRegistered::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  // Process the command.
  if (trigger == CheckIsRegistered::CheckIsRegisteredId)
  {
    ss << "CheckIsRegistered::Process: " << trigger;
    Logger::Instance().LogDebug(ss.str());
    
    return 0; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckIsRegistered::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // See TTCN-3 FncRetCode 
}

void CheckIsRegistered::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

