#ifndef Processors_Processor_h
#define Processors_Processor_h

// Boost headers.
#include <boost/scoped_ptr.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/thread/thread.hpp>
#include <boost/thread/tss.hpp>
// Standard headers.
#include <string>

#include "Processors/ProcessorsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
/*! Class Processor
 * \brief This class implements the ProcessorsImpl interface which provides support for TriggerCommands message processing in local or remote mode.
 */
class Processor : public ProcessorsImpl
{
  //! Implementation of trigger command processing.
  boost::scoped_ptr<Processors::TriggerCommandsStrategy> m_impl;
  //! Asynchronous trigger command processing.
  //boost::shared_ptr<boost::thread> m_asyncProcessing;
  
public:
  //! Processor.
  /*! Default ctor.
   */
  Processor();
  //! ~Processor.
  /*! Default dtor.
   */
  ~Processor();
  
public: // Public interface.
  //! SetImplMode.
  /*! Initialize the communication mode.
   * @param strategy: .
   */
  void SetImplMode(TriggerCommandsStrategy::Strategies strategy);
  //! SetEutIpInterface.
  /*! Initialize the EUT IP interface.
   * @param eutIface: .EUT IP interface.
   */
  void SetEutIpInterface(boost::shared_ptr<EutIPInterface> eutIface);
  //! Process.
  /*! Process the TriggerCommands message in synchronous mode.
   * @param trigger: trigger command to execute
   * @param params: Trigger parameters list
   * @return FncRetCode value on success, -1 otherwise.
   */
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  //! BeginProcess.
  /*! Process the TriggerCommands message in asynchronous mode.
   * @param trigger: trigger command to execute
   * @param params: Trigger parameters list
   * @return true on success, false otherwise.
   */
    /*
  bool BeginProcess(const std::string &trigger, const std::vector<std::string> &parameterList);
  bool ProcessCompleted();
  bool Wait(int timeout);*/

private:
  //static void InvokeProcess();
};

} } // namespaces

#endif // Processors_Processor_h

